/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class NamespaceContextImpl
implements NamespaceContext {
    private static final Logger LOGGER = Logger.getLogger(NamespaceContextImpl.class);
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Document document;

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Lookup prefix '" + prefix + "' for XPath expression"));
        }
        if (prefix == null || "".equals(prefix)) {
            return this.document.lookupNamespaceURI("");
        }
        String namespaceURI = this.prefixes.get(prefix);
        if (namespaceURI == null && this.document != null) {
            if ("".equals(prefix)) {
                return this.document.lookupNamespaceURI("");
            }
            return this.document.lookupNamespaceURI(prefix);
        }
        return namespaceURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String prefix = this.namespaces.get(namespaceURI);
        if (prefix == null && this.document != null) {
            return this.document.lookupPrefix(namespaceURI);
        }
        return prefix;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        String prefix = this.namespaces.get(namespaceURI);
        Collection<String> set = Collections.unmodifiableCollection(Arrays.asList(prefix));
        return set.iterator();
    }

    public void addNamespaceBinding(String prefix, String namespaceURI) {
        this.namespaces.put(namespaceURI, prefix);
        this.prefixes.put(prefix, namespaceURI);
    }

    public String toString() {
        return "NamespaceContextImpl [document=" + this.document + ", namespaces=" + this.namespaces + ", prefixes=" + this.prefixes + "]";
    }
}

