/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.internal.configuration.ValidationAwareXmlParserConfigurator;
import org.sourceprojects.lycia.internal.configuration.XPathConfigutationUtils;
import org.w3c.dom.Element;

public class RankingXmlParserConfigurator<B>
extends ValidationAwareXmlParserConfigurator<B> {
    private static final int RANKING_VALUE_DEFAULT_PARSER = 5;
    private static final int RANKING_VALUE_TAGGED_PARSER = 10;
    private static final int RANKING_VALUE_SPECIAL_PARAMETER_TYPE = 15;
    private static final int RANKING_VALUE_ANNOTATED_PARAMETER_TYPE = 20;
    private final RankComparator<B> rankComparator = new RankComparator();

    public RankingXmlParserConfigurator(LyciaParser<B> xmlParser, LyciaConfigurator<B> parent) {
        super(xmlParser, parent);
    }

    @Override
    public TagDefinitionParser<B> findTagDefinitionParser(QName localElement, Element element) {
        List parsers = this.findTagDefinitionParsers(localElement.getLocalPart(), localElement.getNamespaceURI(), element);
        if (parsers.size() == 0) {
            return null;
        }
        List ranking = this.rankTagDefinitionParsers(parsers, localElement, element);
        return ranking.get(0).getParser();
    }

    @Override
    public List<TagDefinitionParser<B>> findTagDefinitionParsers(QName localElement, Element element) {
        List parsers = super.findTagDefinitionParsers(localElement, element);
        List ranking = this.rankTagDefinitionParsers(parsers, localElement, element);
        parsers = new ArrayList();
        for (RankingContainer rank : ranking) {
            parsers.add(rank.getParser());
        }
        return parsers;
    }

    private List<RankingContainer<B>> rankTagDefinitionParsers(List<TagDefinitionParser<B>> parsers, QName localElement, Element element) {
        ArrayList<RankingContainer<B>> ranking = new ArrayList<RankingContainer<B>>();
        for (TagDefinitionParser<B> parser : parsers) {
            RankingContainer<B> container = new RankingContainer<B>(parser);
            for (Tag tag : parser.getTagAnnotations()) {
                container.addRanking(this.calculatePoints(tag, localElement.getLocalPart(), localElement.getNamespaceURI(), element));
            }
            ranking.add(container);
        }
        Collections.sort(ranking, this.rankComparator);
        return ranking;
    }

    private int calculatePoints(Tag tag, String tagname, String namespaceURI, Element element) {
        String namespace;
        String expression = tag.value();
        String string = namespace = "".equals(tag.namespace()) ? namespaceURI : tag.namespace();
        if (!XPathConfigutationUtils.isNullXPathAnnotation(tag)) {
            return 20;
        }
        if (expression.contains("\\")) {
            QName[] qNames = this.generateParentQNames(expression, namespace);
            boolean found = true;
            for (int i = qNames.length - 1; i > -1; --i) {
                QName qName = qNames[i];
                String localPart = qName.getLocalPart();
                String namespacePart = qName.getNamespaceURI();
                if (!localPart.equals(element.getLocalName()) || !namespacePart.equals(element.getNamespaceURI())) {
                    found = false;
                    break;
                }
                if (i <= 0) continue;
                if (element.getParentNode() == null) {
                    found = false;
                    break;
                }
                element = (Element)element.getParentNode();
            }
            if (found) {
                return 15;
            }
        } else {
            if (expression.equals(tagname) && namespace.equals(namespaceURI)) {
                return 10;
            }
            if (expression.equals("*") && namespace.equals(namespaceURI)) {
                return 5;
            }
        }
        return 0;
    }

    private static class RankComparator<B>
    implements Comparator<RankingContainer<B>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RankComparator() {
        }

        @Override
        public int compare(RankingContainer<B> o1, RankingContainer<B> o2) {
            if (o1.getRanking() == o2.getRanking()) {
                return 0;
            }
            return o1.getRanking() > o2.getRanking() ? -1 : 1;
        }
    }

    private static class RankingContainer<B> {
        private final TagDefinitionParser<B> parser;
        private int ranking = 0;

        public RankingContainer(TagDefinitionParser<B> parser) {
            this.parser = parser;
        }

        public TagDefinitionParser<B> getParser() {
            return this.parser;
        }

        public void addRanking(int value) {
            this.ranking += value;
        }

        public int getRanking() {
            return this.ranking;
        }
    }
}

