/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.TagParser;
import org.sourceprojects.lycia.annotations.TagTransformer;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.lycia.internal.configuration.XPathConfigutationUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TagConfigurationUtils {
    private static final Logger LOGGER = Logger.getLogger(TagConfigurationUtils.class);
    private static final Class<?>[][] LEGAL_PARSER_METHOD_PARAMETERS = new Class[][]{{Element.class, ParserContext.class, DefinitionBuilder.class}, {Element.class, String.class, ParserContext.class, DefinitionBuilder.class}, {Element.class, String.class, QName.class, ParserContext.class, DefinitionBuilder.class}};
    private static final Class<?>[][] LEGAL_TRANSFORMER_METHOD_PARAMETERS = new Class[][]{{Element.class, ParserContext.class, DefinitionBuilder.class}, {Element.class, String.class, ParserContext.class, DefinitionBuilder.class}, {Element.class, String.class, QName.class, ParserContext.class, DefinitionBuilder.class}};
    private static Method BASE_TRANSFORMER_METHOD;
    private static Method BASE_PARSER_METHOD;

    private static boolean isLegalTagHandlerMethod(Method method) {
        Class[][] expectedParameters = null;
        if (method.isAnnotationPresent(TagParser.class)) {
            expectedParameters = LEGAL_PARSER_METHOD_PARAMETERS;
        } else if (method.isAnnotationPresent(TagTransformer.class)) {
            if (!TagConfigurationUtils.isLegalTransformerReturn(method)) {
                return false;
            }
            expectedParameters = LEGAL_TRANSFORMER_METHOD_PARAMETERS;
        }
        if (expectedParameters == null) {
            return false;
        }
        if (method.getExceptionTypes().length == 0) {
            return false;
        }
        boolean found = false;
        for (Class<?> exception : method.getExceptionTypes()) {
            if (!LyciaParsingException.class.isAssignableFrom(exception)) continue;
            found = true;
        }
        if (!found) {
            return false;
        }
        Class<?>[] givenParameters = method.getParameterTypes();
        for (Class[] parameters : expectedParameters) {
            if (!TagConfigurationUtils.isCompatibleSignature(parameters, givenParameters)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleSignature(Class<?>[] expected, Class<?>[] actual) {
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i].isAssignableFrom(actual[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isLegalTransformerReturn(Method method) {
        return method.getReturnType() == Node.class;
    }

    public static MethodDefinition[] findAnnotatedMethods(Class<?> clazz) {
        boolean foundDefaultTagTransformer = false;
        boolean foundDefaultTagParser = false;
        ArrayList<MethodDefinition> foundMethods = new ArrayList<MethodDefinition>();
        for (Method method : clazz.getMethods()) {
            MethodDefinition definition;
            Annotation annotation;
            Tag[] tags;
            if (method.isAnnotationPresent(TagParser.class)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Found @TagParser annotation on method '" + method + "'"));
                }
                if (TagConfigurationUtils.hasDefaultTag(tags = (annotation = method.getAnnotation(TagParser.class)).value())) {
                    if (foundDefaultTagParser) {
                        throw new LyciaConfigurationException("Duplicate default TagParser found on class " + clazz.getCanonicalName());
                    }
                    foundDefaultTagParser = true;
                }
                if (TagConfigurationUtils.isLegalTagHandlerMethod(method)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Method '" + method + "' qualified as legal TagParser method"));
                    }
                    definition = new MethodDefinition(method, tags);
                    foundMethods.add(definition);
                    continue;
                }
                throw new LyciaConfigurationException("Illegal method signature found for TagParser " + method.getName() + " on class " + clazz.getCanonicalName());
            }
            if (!method.isAnnotationPresent(TagTransformer.class)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found @TagTransformer annotation on method '" + method + "'"));
            }
            if (TagConfigurationUtils.hasDefaultTag(tags = (annotation = method.getAnnotation(TagTransformer.class)).value())) {
                if (foundDefaultTagTransformer) {
                    throw new LyciaConfigurationException("Duplicate default TagTransformer found on class " + clazz.getCanonicalName());
                }
                foundDefaultTagTransformer = true;
            }
            if (TagConfigurationUtils.isLegalTagHandlerMethod(method)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Method '" + method + "' qualified as legal TagTransformer method"));
                }
                definition = new MethodDefinition(method, tags);
                foundMethods.add(definition);
                continue;
            }
            throw new LyciaConfigurationException("Illegal method signature found for TagTransformer " + method.getName() + " on class " + clazz.getCanonicalName());
        }
        return foundMethods.toArray(new MethodDefinition[foundMethods.size()]);
    }

    private static boolean hasDefaultTag(Tag[] tags) {
        for (Tag tag : tags) {
            if (!"*".equals(tag.value()) || !XPathConfigutationUtils.isNullXPathAnnotation(tag)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Method getBaseTransformerMethod() throws SecurityException, NoSuchMethodException {
        if (BASE_TRANSFORMER_METHOD == null) {
            BASE_TRANSFORMER_METHOD = TagDefinitionParser.class.getMethod("transformElement", LEGAL_TRANSFORMER_METHOD_PARAMETERS[2]);
        }
        return BASE_TRANSFORMER_METHOD;
    }

    public static synchronized Method getBaseParserMethod() throws SecurityException, NoSuchMethodException {
        if (BASE_PARSER_METHOD == null) {
            BASE_PARSER_METHOD = TagDefinitionParser.class.getMethod("parseElement", LEGAL_PARSER_METHOD_PARAMETERS[2]);
        }
        return BASE_PARSER_METHOD;
    }

    public static <B> Object[] generateParameter(Method method, Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) {
        Object[] result = new Object[method.getParameterTypes().length];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resolving parameters for method '" + method + "'"));
        }
        switch (method.getParameterTypes().length) {
            case 3: {
                result[0] = element;
                result[1] = parserContext;
                result[2] = definitionBuilder;
                break;
            }
            case 4: {
                result[0] = element;
                result[1] = localName;
                result[2] = parserContext;
                result[3] = definitionBuilder;
                break;
            }
            case 5: {
                result[0] = element;
                result[1] = localName;
                result[2] = parent;
                result[3] = parserContext;
                result[4] = definitionBuilder;
                break;
            }
        }
        return result;
    }

    public static class MethodDefinition {
        private final Tag[] tags;
        private final Method method;

        public MethodDefinition(Method method, Tag ... tags) {
            this.method = method;
            this.tags = tags;
        }

        public Tag[] getTags() {
            Tag[] result = new Tag[this.tags.length];
            System.arraycopy(this.tags, 0, result, 0, this.tags.length);
            return result;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

