/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.sourceprojects.lycia.LyciaConfigurator;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.annotations.Validator;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.internal.configuration.AnnotatedXmlParserConfigurator;
import org.sourceprojects.lycia.internal.validation.ConstraintValidatorUtils;
import org.sourceprojects.lycia.internal.validation.PropertyDescriptorImpl;
import org.w3c.dom.Element;

public class ValidationAwareXmlParserConfigurator<B>
extends AnnotatedXmlParserConfigurator<B> {
    public ValidationAwareXmlParserConfigurator(LyciaParser<B> xmlParser, LyciaConfigurator<B> parent) {
        super(xmlParser, parent);
    }

    @Override
    public List<TagDefinitionParser<B>> findTagDefinitionParsers(QName localElement, Element element) {
        List parsers = super.findTagDefinitionParsers(localElement, element);
        Iterator iterator = parsers.iterator();
        while (iterator.hasNext()) {
            Tag[] tags;
            TagDefinitionParser parser = iterator.next();
            for (Tag tag : tags = parser.getTagAnnotations()) {
                PropertyDescriptorImpl[] properties = this.findValidators(tag);
                if (ConstraintValidatorUtils.checkConstraints(properties, element)) continue;
                iterator.remove();
            }
        }
        return parsers;
    }

    private PropertyDescriptorImpl[] findValidators(Tag tag) {
        if (tag.validations() == null || tag.validations().length == 0) {
            return new PropertyDescriptorImpl[0];
        }
        int i$ = 0;
        Validator[] arr$ = tag.validations();
        int len$ = arr$.length;
        if (i$ < len$) {
            Validator validator = arr$[i$];
            Class<?> impl = validator.value();
            try {
                return this.findValidationFields(impl);
            }
            catch (IntrospectionException e) {
                throw new LyciaConfigurationException("Failure while validating fields", e);
            }
        }
        return new PropertyDescriptorImpl[0];
    }

    private PropertyDescriptorImpl[] findValidationFields(Class<?> validator) throws IntrospectionException {
        ArrayList<PropertyDescriptorImpl> result = new ArrayList<PropertyDescriptorImpl>();
        for (Field field : validator.getDeclaredFields()) {
            if (ConstraintValidatorUtils.getCompliantAnnotations(field).length <= 0) continue;
            result.add(new PropertyDescriptorImpl(field, validator));
        }
        return result.toArray(new PropertyDescriptorImpl[result.size()]);
    }
}

