/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.TagDefinitionParser;
import org.sourceprojects.lycia.annotations.Namespace;
import org.sourceprojects.lycia.annotations.Tag;
import org.sourceprojects.lycia.internal.Cache;
import org.sourceprojects.lycia.internal.configuration.NamespaceContextImpl;
import org.sourceprojects.lycia.internal.configuration.XPathExpressionImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathConfigutationUtils {
    private static final Logger LOGGER = Logger.getLogger(XPathConfigutationUtils.class);

    private XPathConfigutationUtils() {
    }

    public static final XPathExpression compileExpression(String expression, Namespace[] namespaces) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(XPathConfigutationUtils.buildNamespaceContext(namespaces));
        try {
            return new XPathExpressionImpl(xpath.compile(expression));
        }
        catch (XPathExpressionException e) {
            return new XPathExpressionImpl(null, xpath, expression);
        }
    }

    public static final boolean matches(Element element, XPathExpression compiled, Cache<NodeList> cache, LyciaParser<?> xmlParser) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Trying to retrieve cached NodeList");
            }
            NodeList result = null;
            if (cache != null) {
                result = cache.get(String.valueOf(compiled.hashCode()));
            }
            if (result == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"No cached NodeList found, building it");
                }
                if (compiled instanceof XPathExpressionImpl) {
                    XPathExpressionImpl impl = (XPathExpressionImpl)compiled;
                    impl.setDocument(element.getOwnerDocument());
                }
                result = (NodeList)compiled.evaluate(element, XPathConstants.NODESET);
                if (cache != null) {
                    cache.put(String.valueOf(compiled.hashCode()), result, xmlParser.getCacheExpirationTime());
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Cached NodeList found, using this one");
            }
            if (result != null) {
                for (int i = 0; i < result.getLength(); ++i) {
                    Node node = result.item(i);
                    if (node != element) continue;
                    return true;
                }
            }
            return false;
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    public static final boolean isNullXPathAnnotation(Tag tag) {
        org.sourceprojects.lycia.annotations.XPath xpath = tag.xpath();
        return xpath.expression().equals("~~NULL~~") && xpath.namespaces().length == 0;
    }

    public static final <B> boolean isHandleNamespace(TagDefinitionParser<B> parser, String namespaceURI) {
        for (Tag tag : parser.getTagAnnotations()) {
            if (XPathConfigutationUtils.isNullXPathAnnotation(tag) || tag.xpath().namespaces().length <= 0) continue;
            for (Namespace namespace : tag.xpath().namespaces()) {
                if (!namespace.uri().equals(namespaceURI)) continue;
                return true;
            }
        }
        return false;
    }

    private static final NamespaceContext buildNamespaceContext(Namespace[] namespaces) {
        if (namespaces == null) {
            return null;
        }
        NamespaceContextImpl context = new NamespaceContextImpl();
        for (Namespace namespace : namespaces) {
            if (namespace == null || namespace.prefix() == null || namespace.uri() == null) continue;
            context.addNamespaceBinding(namespace.prefix(), namespace.uri());
        }
        return context;
    }
}

