/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.configuration;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.internal.configuration.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private final XPathExpression compiledExpression;
    private final String expression;
    private final XPath xpath;
    private Document document = null;

    public XPathExpressionImpl(XPathExpression compiledExpression) {
        this.compiledExpression = compiledExpression;
        this.expression = null;
        this.xpath = null;
    }

    public XPathExpressionImpl(XPathExpression compiledExpression, XPath xpath, String expression) {
        this.compiledExpression = compiledExpression;
        this.expression = expression;
        this.xpath = xpath;
    }

    @Override
    public String evaluate(Object item) throws XPathExpressionException {
        if (this.xpath != null && this.document != null && this.expression != null) {
            return this.xpath.evaluate(this.expression, item);
        }
        return this.compiledExpression.evaluate(item);
    }

    @Override
    public String evaluate(InputSource source) throws XPathExpressionException {
        if (this.xpath != null && this.document != null && this.expression != null) {
            return this.xpath.evaluate(this.expression, source);
        }
        return this.compiledExpression.evaluate(source);
    }

    @Override
    public Object evaluate(Object item, QName returnType) throws XPathExpressionException {
        if (this.xpath != null && this.document != null && this.expression != null) {
            try {
                return this.xpath.evaluate(this.expression, item, returnType);
            }
            catch (XPathExpressionException e) {
                throw new LyciaConfigurationException("Parsing expression", e);
            }
        }
        return this.compiledExpression.evaluate(item, returnType);
    }

    @Override
    public Object evaluate(InputSource source, QName returnType) throws XPathExpressionException {
        if (this.xpath != null && this.document != null && this.expression != null) {
            return this.xpath.evaluate(this.expression, source, returnType);
        }
        return this.compiledExpression.evaluate(source, returnType);
    }

    public void setDocument(Document document) {
        this.document = document;
        if (this.xpath != null && this.xpath.getNamespaceContext() instanceof NamespaceContextImpl) {
            ((NamespaceContextImpl)this.xpath.getNamespaceContext()).setDocument(document);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public String getExpression() {
        return this.expression;
    }
}

