/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.dom;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.NamespaceResolver;
import org.sourceprojects.lycia.ResourceResolver;
import org.sourceprojects.lycia.exceptions.LyciaInitializationException;
import org.sourceprojects.lycia.internal.resolver.BasicNamespaceResolver;
import org.w3c.dom.ls.LSInput;

public class ResourceResolverImpl
implements ResourceResolver {
    private static final Logger LOGGER = Logger.getLogger(ResourceResolverImpl.class);
    private final Map<String, NamespaceResolver> namespaceResolvers = new HashMap<String, NamespaceResolver>();
    private final BasicNamespaceResolver basicNamespaceResolver;
    private boolean showWarning = true;

    public ResourceResolverImpl() {
        try {
            ArrayList<BasicNamespaceResolver.NamespaceResolverHandlerContainer> containers = new ArrayList<BasicNamespaceResolver.NamespaceResolverHandlerContainer>();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> xmlparserResources = cl.getResources("META-INF/xmlparser/schema.properties");
            this.readRedirects(containers, xmlparserResources);
            Enumeration<URL> lyciaResources = cl.getResources("META-INF/lycia/schema.properties");
            this.readRedirects(containers, lyciaResources);
            BasicNamespaceResolver.NamespaceResolverHandlerContainer[] handler = new BasicNamespaceResolver.NamespaceResolverHandlerContainer[containers.size()];
            containers.toArray(handler);
            this.basicNamespaceResolver = new BasicNamespaceResolver(handler, cl);
        }
        catch (IOException e) {
            throw new LyciaInitializationException("Failed internal initialization", e);
        }
    }

    private void readRedirects(List<BasicNamespaceResolver.NamespaceResolverHandlerContainer> containers, Enumeration<URL> resources) throws IOException {
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            LOGGER.info((Object)("Found schema.properties in '" + url.toString() + "'"));
            Properties properties = new Properties();
            properties.load(url.openStream());
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                containers.add(new BasicNamespaceResolver.NamespaceResolverHandlerContainer(key, value));
            }
        }
    }

    @Override
    public boolean isShowWarning() {
        return this.showWarning;
    }

    @Override
    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    @Override
    public void registerNamespaceResolver(NamespaceResolver namespaceResolver) {
        String namespaceURI = namespaceResolver.getNamespaceURI();
        if (this.namespaceResolvers.get(namespaceURI) != null && this.isShowWarning()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Namespace ").append(namespaceURI).append(" is already defined and will be overridden.");
            LOGGER.warn((Object)sb.toString());
        }
        this.namespaceResolvers.put(namespaceURI, namespaceResolver);
    }

    @Override
    public void unregisterNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.unregisterNamespaceResolver(namespaceResolver.getNamespaceURI());
    }

    @Override
    public void unregisterNamespaceResolver(String namespaceURI) {
        this.namespaceResolvers.remove(namespaceURI);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        NamespaceResolver resolver = this.namespaceResolvers.get(namespaceURI);
        if (resolver != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Found NamespaceResolver for namespace '" + namespaceURI + "'"));
            }
            return resolver.getInput(type, namespaceURI, publicId, systemId, baseURI);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Using BasicNamespaceResolver for namespace '" + namespaceURI + "'"));
        }
        return this.basicNamespaceResolver.getInput(type, namespaceURI, publicId, systemId, baseURI);
    }

    public String toString() {
        return "ResourceResolverImpl [basicNamespaceResolver=" + this.basicNamespaceResolver + ", namespaceResolvers=" + this.namespaceResolvers + ", showWarning=" + this.showWarning + "]";
    }
}

