/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.generator;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckMethodAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.internal.configuration.TagConfigurationUtils;
import org.sourceprojects.lycia.internal.generator.BytecodeDelegate;
import org.sourceprojects.lycia.internal.generator.GeneratorClassLoader;
import org.sourceprojects.lycia.internal.privileged.CreateClassLoader;
import org.w3c.dom.Element;

public class BytecodeGenerator<T>
implements Generator<T>,
Opcodes {
    private static final String PARSE_SIGNATURE_THREE_PARAMS = "(Lorg/w3c/dom/Element;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V";
    private static final String PARSE_SIGNATURE_FOUR_PARAMS = "(Lorg/w3c/dom/Element;Ljava/lang/String;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V";
    private static final String PARSE_SIGNATURE_FIVE_PARAMS = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V";
    private static final String TRANSFORM_SIGNATURE_THREE_PARAMS = "(Lorg/w3c/dom/Element;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;))Lorg/w3c/dom/Node;";
    private static final String TRANSFORM_SIGNATURE_FOUR_PARAMS = "(Lorg/w3c/dom/Element;Ljava/lang/String;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;";
    private static final String TRANSFORM_SIGNATURE_FIVE_PARAMS = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;";
    private static final String PARSE_SIGNATURE_DELEGATE = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V";
    private static final String PARSE_SIGNATURE_DELEGATE_GENERIFIED = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext<TT;>;Lorg/sourceprojects/lycia/DefinitionBuilder;)V";
    private static final String TRANSFORM_SIGNATURE_DELEGATE = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;";
    private static final String TRANSFORM_SIGNATURE_DELEGATE_GENERIFIED = "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext<Ljava/lang/StringBuilder;>;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;";
    private static final String EXCEPTION_CLASS = "org/sourceprojects/lycia/exceptions/XmlParserParsingException";
    private static final String SUPER_CLASS = "org/sourceprojects/lycia/internal/generator/BytecodeDelegate";
    private static final String PARSE_METHOD_NAME = "invokeParse";
    private static final String TRANSFORM_METHOD_NAME = "invokeTransform";
    private static final int METHOD_ACCESS = 17;
    private static final AtomicLong LONG = new AtomicLong(0L);
    private final GeneratorClassLoader classloader = CreateClassLoader.createClassLoader(this.getClass().getClassLoader());

    @Override
    public Delegate<T> generate(Object parser, TagConfigurationUtils.MethodDefinition methodDefinition) {
        try {
            long id = LONG.getAndIncrement();
            StringBuilder classname = new StringBuilder();
            classname.append("BytecodeGenerated").append(id);
            ClassWriter cw = new ClassWriter(0);
            cw.visit(50, 33, classname.toString(), this.toGenerifiedInternalRepresentation(classname.toString()), SUPER_CLASS, null);
            this.createConstructor((ClassVisitor)cw);
            if (methodDefinition.getMethod().getReturnType() != Element.class) {
                this.createParseMethod((ClassVisitor)cw, methodDefinition);
                this.callAReturn((ClassVisitor)cw);
            } else {
                this.callReturn((ClassVisitor)cw);
                this.createTransformMethod((ClassVisitor)cw, methodDefinition);
            }
            cw.visitEnd();
            byte[] bytecode = cw.toByteArray();
            Class clazz = this.classloader.loadClass(bytecode);
            BytecodeDelegate instance = (BytecodeDelegate)clazz.newInstance();
            instance.setParser(parser);
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new LyciaConfigurationException("BytecodeGenerator could not generate Delegate for parser '" + parser + "'", e);
        }
        catch (InstantiationException e) {
            throw new LyciaConfigurationException("BytecodeGenerator could not generate Delegate for parser '" + parser + "'", e);
        }
    }

    private MethodVisitor createConstructor(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, SUPER_CLASS, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return mv;
    }

    private MethodVisitor createParseMethod(ClassVisitor cw, TagConfigurationUtils.MethodDefinition methodDefinition) {
        MethodVisitor mv = cw.visitMethod(17, PARSE_METHOD_NAME, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V", PARSE_SIGNATURE_DELEGATE_GENERIFIED, new String[]{EXCEPTION_CLASS});
        TraceMethodVisitor tmv = new TraceMethodVisitor(mv);
        CheckMethodAdapter cma = new CheckMethodAdapter((MethodVisitor)tmv);
        cma.visitCode();
        this.callParseParameter((MethodVisitor)cma, methodDefinition.getMethod());
        cma.visitEnd();
        return mv;
    }

    private void callParseParameter(MethodVisitor mv, Method method) {
        String classname = method.getDeclaringClass().getCanonicalName();
        String methodname = method.getName();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, SUPER_CLASS, "getParser", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, this.toInternalRepresentation(classname));
        mv.visitVarInsn(58, 6);
        mv.visitVarInsn(25, 6);
        switch (method.getParameterTypes().length) {
            case 3: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, PARSE_SIGNATURE_THREE_PARAMS);
                break;
            }
            case 4: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, PARSE_SIGNATURE_FOUR_PARAMS);
                break;
            }
            default: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(8, 7);
    }

    private MethodVisitor createTransformMethod(ClassVisitor cw, TagConfigurationUtils.MethodDefinition methodDefinition) {
        MethodVisitor mv = cw.visitMethod(17, TRANSFORM_METHOD_NAME, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;", TRANSFORM_SIGNATURE_DELEGATE_GENERIFIED, new String[]{EXCEPTION_CLASS});
        mv.visitCode();
        this.callTransformParameter(mv, methodDefinition.getMethod());
        mv.visitEnd();
        return mv;
    }

    private void callTransformParameter(MethodVisitor mv, Method method) {
        String classname = method.getDeclaringClass().getCanonicalName();
        String methodname = method.getName();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, SUPER_CLASS, "getParser", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, this.toInternalRepresentation(classname));
        mv.visitVarInsn(58, 6);
        mv.visitVarInsn(25, 6);
        switch (method.getParameterTypes().length) {
            case 3: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, TRANSFORM_SIGNATURE_THREE_PARAMS);
                break;
            }
            case 4: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, TRANSFORM_SIGNATURE_FOUR_PARAMS);
                break;
            }
            default: {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(25, 3);
                mv.visitVarInsn(25, 4);
                mv.visitVarInsn(25, 5);
                mv.visitMethodInsn(182, this.toInternalRepresentation(classname), methodname, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 7);
    }

    private String toInternalRepresentation(String classname) {
        return classname.replace(".", "/");
    }

    private String toGenerifiedInternalRepresentation(String classname) {
        return "<T:Ljava/lang/Object;>L" + this.toInternalRepresentation(classname) + "<TT;>;";
    }

    private void callReturn(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(17, PARSE_METHOD_NAME, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)V", null, new String[]{EXCEPTION_CLASS});
        mv.visitInsn(177);
        mv.visitMaxs(0, 6);
        mv.visitEnd();
    }

    private void callAReturn(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(17, TRANSFORM_METHOD_NAME, "(Lorg/w3c/dom/Element;Ljava/lang/String;Ljavax/xml/namespace/QName;Lorg/sourceprojects/lycia/ParserContext;Lorg/sourceprojects/lycia/DefinitionBuilder;)Lorg/w3c/dom/Node;", null, new String[]{EXCEPTION_CLASS});
        mv.visitCode();
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(1, 6);
        mv.visitEnd();
    }
}

