/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.generator;

import org.sourceprojects.lycia.Generator;
import org.sourceprojects.lycia.GeneratorFactory;
import org.sourceprojects.lycia.LyciaBuilder;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;

public class GeneratorFactoryImpl<T>
implements GeneratorFactory<T> {
    private static final String REFLECTIVE_GENERATOR = "org.sourceprojects.lycia.internal.generator.ReflectiveGenerator";
    private static final String BYTECODE_GENERATOR = "org.sourceprojects.lycia.internal.generator.BytecodeGenerator";
    private Class<? extends Generator<?>> CUSTOM_GENERATOR_CLASS = null;

    @Override
    public final Generator<T> newInstance(LyciaBuilder.GenerationStrategy generationStrategy) {
        try {
            Class<Object> clazz;
            switch (generationStrategy) {
                case BytecodeGeneration: {
                    clazz = Class.forName(BYTECODE_GENERATOR);
                    break;
                }
                case ReflectiveGeneration: {
                    clazz = Class.forName(REFLECTIVE_GENERATOR);
                    break;
                }
                case Customized: {
                    if (this.CUSTOM_GENERATOR_CLASS != null) {
                        clazz = this.CUSTOM_GENERATOR_CLASS;
                        break;
                    }
                }
                default: {
                    throw new LyciaConfigurationException("GenerationStrategy is not yet supported");
                }
            }
            return (Generator)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new LyciaConfigurationException("GeneratorStrategy could not be initialized", e);
        }
        catch (InstantiationException e) {
            throw new LyciaConfigurationException("GeneratorStrategy could not be initialized", e);
        }
        catch (IllegalAccessException e) {
            throw new LyciaConfigurationException("GeneratorStrategy could not be initialized", e);
        }
    }

    @Override
    public final void setCustomGeneratorClass(Class<? extends Generator<T>> clazz) {
        this.CUSTOM_GENERATOR_CLASS = clazz;
    }
}

