/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.sourceprojects.lycia.DefinitionBuilder;
import org.sourceprojects.lycia.Delegate;
import org.sourceprojects.lycia.ParserContext;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.lycia.internal.configuration.TagConfigurationUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ReflectiveDelegate<B>
implements Delegate<B> {
    private final Object parser;
    private final Method method;

    ReflectiveDelegate(Object parser, Method method) {
        this.parser = parser;
        this.method = method;
    }

    @Override
    public void invokeParse(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        try {
            Object[] parameters = TagConfigurationUtils.generateParameter(this.method, element, localName, parent, parserContext, definitionBuilder);
            this.method.invoke(this.parser, parameters);
        }
        catch (IllegalAccessException e) {
            throw new LyciaParsingException("Parser method " + this.method.getName() + " could not be executed", e);
        }
        catch (InvocationTargetException e) {
            throw new LyciaParsingException("Parser method " + this.method.getName() + " could not be executed", e);
        }
        catch (IllegalArgumentException e) {
            throw new LyciaParsingException("Parser method " + this.method.getName() + " could not be executed", e);
        }
    }

    @Override
    public Node invokeTransform(Element element, String localName, QName parent, ParserContext<B> parserContext, DefinitionBuilder definitionBuilder) throws LyciaParsingException {
        try {
            Object[] parameters = TagConfigurationUtils.generateParameter(this.method, element, localName, parent, parserContext, definitionBuilder);
            return (Node)this.method.invoke(this.parser, parameters);
        }
        catch (IllegalAccessException e) {
            throw new LyciaParsingException("Transformer method " + this.method.getName() + " could not be executed", e);
        }
        catch (InvocationTargetException e) {
            throw new LyciaParsingException("Transformer method " + this.method.getName() + " could not be executed", e);
        }
        catch (IllegalArgumentException e) {
            throw new LyciaParsingException("Transformer method " + this.method.getName() + " could not be executed", e);
        }
    }

    public String toString() {
        return "ReflectiveDelegate [method=" + this.method + ", parser=" + this.parser + "]";
    }
}

