/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.io;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.annotations.AfterPropertySet;
import org.sourceprojects.lycia.internal.EntityResolverImpl;
import org.sourceprojects.lycia.io.LyciaReader;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LyciaXmlReader<B>
implements LyciaReader<B> {
    private static final Logger LOGGER = Logger.getLogger(LyciaXmlReader.class);
    private LyciaParser<B> xmlParser;

    @Override
    public LyciaParser<B> getXmlParser() {
        return this.xmlParser;
    }

    @Override
    public Document read(InputSource inputSource) throws Exception {
        DocumentBuilder builder = this.createDocumentBuilder();
        builder.setEntityResolver(new EntityResolverImpl(this.xmlParser.getResourceResolver()));
        return builder.parse(inputSource);
    }

    @Override
    public void setXmlParser(LyciaParser<B> xmlParser) {
        this.xmlParser = xmlParser;
    }

    @AfterPropertySet
    public void afterPropertySet() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"AfterPropertySet called");
        }
    }

    private DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        if (this.xmlParser.isValidatingSchema()) {
            try {
                factory.setSchema(this.createSchema());
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warn((Object)"Warning: Schema isn't supported");
            }
        }
        return factory.newDocumentBuilder();
    }

    private Schema createSchema() throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(this.xmlParser.getResourceResolver());
        factory.setErrorHandler(this.xmlParser.getErrorHandler());
        return factory.newSchema();
    }
}

