/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.resolver;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.NamespaceResolver;
import org.sourceprojects.lycia.internal.dom.LSInputImpl;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

public class BasicNamespaceResolver
implements NamespaceResolver {
    private static final Logger LOGGER = Logger.getLogger(BasicNamespaceResolver.class);
    private final NamespaceResolverHandlerContainer[] containers;
    private final ClassLoader classLoader;

    public BasicNamespaceResolver(NamespaceResolverHandlerContainer[] containers, ClassLoader classLoader) {
        this.containers = new NamespaceResolverHandlerContainer[containers.length];
        System.arraycopy(containers, 0, this.containers, 0, containers.length);
        this.classLoader = classLoader;
    }

    @Override
    public LSInput getInput(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        for (NamespaceResolverHandlerContainer container : this.containers) {
            if (!container.getNamespaceURI().equals(namespaceURI) && !container.getNamespaceURI().equals(systemId)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Redirecting namespace '" + namespaceURI + "' or systemId '" + systemId + "' to '" + container.getRedirectedURI() + "'"));
            }
            InputStream is = this.getByteStream(container.getRedirectedURI());
            LSInputImpl input = new LSInputImpl();
            input.setBaseURI(baseURI);
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setByteStream(is);
            return input;
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)registry.getDOMImplementation("XML").getFeature("LS", "");
            return impl.createLSInput();
        }
        catch (ClassCastException e) {
            return new LSInputImpl();
        }
        catch (ClassNotFoundException e) {
            return new LSInputImpl();
        }
        catch (InstantiationException e) {
            return new LSInputImpl();
        }
        catch (IllegalAccessException e) {
            return new LSInputImpl();
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    private InputStream getByteStream(String uri) {
        return this.classLoader.getResourceAsStream(uri);
    }

    public String toString() {
        return "BasicNamespaceResolver [classLoader=" + this.classLoader + ", containers=" + Arrays.toString(this.containers) + "]";
    }

    public static class NamespaceResolverHandlerContainer {
        private final String namespaceURI;
        private final String redirectedURI;

        public NamespaceResolverHandlerContainer(String namespaceURI, String redirectedURI) {
            this.namespaceURI = namespaceURI;
            this.redirectedURI = redirectedURI;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getRedirectedURI() {
            return this.redirectedURI;
        }

        public String toString() {
            return "NamespaceResolverHandlerContainer [namespaceURI=" + this.namespaceURI + ", redirectedURI=" + this.redirectedURI + "]";
        }
    }
}

