/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sourceprojects.lycia.ConstraintValidator;
import org.sourceprojects.lycia.annotations.AssertFalse;
import org.sourceprojects.lycia.annotations.AssertTrue;
import org.sourceprojects.lycia.annotations.Constraint;
import org.sourceprojects.lycia.annotations.DecimalMax;
import org.sourceprojects.lycia.annotations.DecimalMin;
import org.sourceprojects.lycia.annotations.Digits;
import org.sourceprojects.lycia.annotations.Empty;
import org.sourceprojects.lycia.annotations.Future;
import org.sourceprojects.lycia.annotations.Max;
import org.sourceprojects.lycia.annotations.Min;
import org.sourceprojects.lycia.annotations.NotEmpty;
import org.sourceprojects.lycia.annotations.NotNull;
import org.sourceprojects.lycia.annotations.Null;
import org.sourceprojects.lycia.annotations.Past;
import org.sourceprojects.lycia.annotations.Pattern;
import org.sourceprojects.lycia.annotations.Size;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;
import org.sourceprojects.lycia.internal.validation.AssertFalseConstraintValidator;
import org.sourceprojects.lycia.internal.validation.AssertTrueConstraintValidator;
import org.sourceprojects.lycia.internal.validation.DecimalMaxConstraintValidator;
import org.sourceprojects.lycia.internal.validation.DecimalMinConstraintValidator;
import org.sourceprojects.lycia.internal.validation.DigitsConstraintValidator;
import org.sourceprojects.lycia.internal.validation.EmptyConstraintValidator;
import org.sourceprojects.lycia.internal.validation.FutureConstraintValidator;
import org.sourceprojects.lycia.internal.validation.MaxConstraintValidator;
import org.sourceprojects.lycia.internal.validation.MinConstraintValidator;
import org.sourceprojects.lycia.internal.validation.NotEmptyConstraintValidator;
import org.sourceprojects.lycia.internal.validation.NotNullConstraintValidator;
import org.sourceprojects.lycia.internal.validation.NullConstraintValidator;
import org.sourceprojects.lycia.internal.validation.PastConstraintValidator;
import org.sourceprojects.lycia.internal.validation.PatternConstraintValidator;
import org.sourceprojects.lycia.internal.validation.PropertyDescriptorImpl;
import org.sourceprojects.lycia.internal.validation.SizeConstraintValidator;
import org.w3c.dom.Element;

public class ConstraintValidatorUtils {
    private static final Map<Class<? extends Annotation>, Class<? extends ConstraintValidator<?>>[]> MAPPING = new HashMap<Class<? extends Annotation>, Class<? extends ConstraintValidator<?>>[]>();

    private ConstraintValidatorUtils() {
    }

    public static boolean checkConstraints(PropertyDescriptorImpl[] properties, Element element) {
        for (PropertyDescriptorImpl property : properties) {
            Annotation[] annotations;
            Field field = property.getField();
            for (Annotation annotation : annotations = ConstraintValidatorUtils.getCompliantAnnotations(field)) {
                ConstraintValidator<Annotation>[] validators = ConstraintValidatorUtils.findConstraintValidators(annotation);
                if (validators == null) continue;
                for (ConstraintValidator<Annotation> validator : validators) {
                    validator.initialize(annotation);
                    String attribute = element.getAttribute(field.getName());
                    if (validator.isValid(attribute)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Annotation[] getCompliantAnnotations(Field field) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(Constraint.class) == null) continue;
            annotations.add(annotation);
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static <A extends Annotation> ConstraintValidator<A>[] findConstraintValidators(A annotation) {
        Class<ConstraintValidator<?>>[] classes = ConstraintValidatorUtils.findConstraintValidators0(annotation);
        if (classes == null || classes.length == 0) {
            classes = MAPPING.get(annotation.annotationType());
        }
        if (classes == null || classes.length == 0) {
            throw new LyciaConfigurationException("No ConstraintValidator class for annotation " + annotation.annotationType().getCanonicalName() + " found");
        }
        try {
            ConstraintValidator[] validators = new ConstraintValidator[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                Class<ConstraintValidator<?>> clazz = classes[i];
                validators[i] = clazz.newInstance();
            }
            return validators;
        }
        catch (InstantiationException e) {
            throw new LyciaConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new LyciaConfigurationException(e);
        }
    }

    private static <A extends Annotation> Class<? extends ConstraintValidator<?>>[] findConstraintValidators0(A annotation) {
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint != null) {
            return constraint.validatedBy();
        }
        return new Class[0];
    }

    static {
        MAPPING.put(AssertFalse.class, new Class[]{AssertFalseConstraintValidator.class});
        MAPPING.put(AssertTrue.class, new Class[]{AssertTrueConstraintValidator.class});
        MAPPING.put(DecimalMax.class, new Class[]{DecimalMaxConstraintValidator.class});
        MAPPING.put(DecimalMin.class, new Class[]{DecimalMinConstraintValidator.class});
        MAPPING.put(Digits.class, new Class[]{DigitsConstraintValidator.class});
        MAPPING.put(Empty.class, new Class[]{EmptyConstraintValidator.class});
        MAPPING.put(Future.class, new Class[]{FutureConstraintValidator.class});
        MAPPING.put(Max.class, new Class[]{MaxConstraintValidator.class});
        MAPPING.put(Min.class, new Class[]{MinConstraintValidator.class});
        MAPPING.put(NotEmpty.class, new Class[]{NotEmptyConstraintValidator.class});
        MAPPING.put(NotNull.class, new Class[]{NotNullConstraintValidator.class});
        MAPPING.put(Null.class, new Class[]{NullConstraintValidator.class});
        MAPPING.put(Past.class, new Class[]{PastConstraintValidator.class});
        MAPPING.put(Pattern.class, new Class[]{PatternConstraintValidator.class});
        MAPPING.put(Size.class, new Class[]{SizeConstraintValidator.class});
    }
}

