/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.validation;

import org.sourceprojects.lycia.ConstraintValidator;
import org.sourceprojects.lycia.annotations.DecimalMin;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;

public class DecimalMinConstraintValidator
implements ConstraintValidator<DecimalMin> {
    private DecimalMin annotation;

    @Override
    public void initialize(DecimalMin annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(Object object) {
        if (object == null) {
            return true;
        }
        try {
            double value = Double.parseDouble(object.toString());
            double expected = Double.parseDouble(this.annotation.value());
            return value > expected;
        }
        catch (NumberFormatException e) {
            throw new LyciaConfigurationException("@DecimalMin could not be parsed", e);
        }
    }
}

