/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.sourceprojects.lycia.ConstraintValidator;
import org.sourceprojects.lycia.annotations.Past;
import org.sourceprojects.lycia.exceptions.LyciaConfigurationException;

public class PastConstraintValidator
implements ConstraintValidator<Past> {
    @Override
    public void initialize(Past annotation) {
    }

    @Override
    public boolean isValid(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Date) {
            return ((Date)object).after(new Date());
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).after(new Date());
        }
        if (object instanceof String) {
            try {
                Date date = DateFormat.getInstance().parse((String)object);
                return date.after(new Date());
            }
            catch (ParseException e) {
                throw new LyciaConfigurationException("Could not parse value for @Past annotation", e);
            }
        }
        throw new LyciaConfigurationException("Could not handle value for @Past annotation");
    }
}

