/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.lycia.internal.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sourceprojects.lycia.ConstraintValidator;
import org.sourceprojects.lycia.annotations.Pattern;

public class PatternConstraintValidator
implements ConstraintValidator<org.sourceprojects.lycia.annotations.Pattern> {
    private Pattern pattern;

    @Override
    public void initialize(org.sourceprojects.lycia.annotations.Pattern annotation) {
        int flags = 0;
        for (Pattern.Flag flag : annotation.flags()) {
            flags |= this.getFlagValue(flag);
        }
        this.pattern = Pattern.compile(annotation.regexp(), flags);
    }

    @Override
    public boolean isValid(Object object) {
        if (object == null) {
            return true;
        }
        String value = object.toString();
        Matcher matcher = this.pattern.matcher(value);
        return matcher.matches();
    }

    private int getFlagValue(Pattern.Flag flag) {
        switch (flag) {
            case CANON_EQ: {
                return 128;
            }
            case CASE_INSENSITIVE: {
                return 2;
            }
            case COMMENTS: {
                return 4;
            }
            case DOTALL: {
                return 32;
            }
            case MULTILINE: {
                return 8;
            }
            case UNICODE_CASE: {
                return 64;
            }
            case UNIX_LINES: {
                return 1;
            }
        }
        return 0;
    }
}

