/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.xmlparser.internal;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.sourceprojects.lycia.LyciaParser;
import org.sourceprojects.lycia.exceptions.LyciaParsingException;
import org.sourceprojects.xmlparser.ParserContext;
import org.sourceprojects.xmlparser.ProgressListener;
import org.sourceprojects.xmlparser.ResourceResolver;
import org.sourceprojects.xmlparser.TagDefinitionParser;
import org.sourceprojects.xmlparser.XmlParser;
import org.sourceprojects.xmlparser.exceptions.XmlParserParsingException;
import org.sourceprojects.xmlparser.internal.ProgressListenerAdapter;
import org.sourceprojects.xmlparser.internal.ResourceResolverAdapter;
import org.sourceprojects.xmlparser.internal.TagDefinitionParserAdapter;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class XmlParserAdapter<B>
implements XmlParser<B> {
    private static final Logger LOGGER = Logger.getLogger((String)XmlParserAdapter.class.getName());
    private final LyciaParser<B> lyciaParser;
    private final List<ProgressListenerAdapter> listenerAdapters = new ArrayList<ProgressListenerAdapter>();
    private final List<TagDefinitionParserAdapter<B>> parserAdapters = new ArrayList<TagDefinitionParserAdapter<B>>();

    public XmlParserAdapter(LyciaParser<B> lyciaParser) {
        this.lyciaParser = lyciaParser;
    }

    public void addProgressListener(ProgressListener listener) {
        ProgressListenerAdapter adapter = new ProgressListenerAdapter(listener);
        this.lyciaParser.addProgressListener(adapter);
        this.listenerAdapters.add(adapter);
    }

    public void addTagDefinitionParser(TagDefinitionParser<B> definitionParser) {
        TagDefinitionParserAdapter<B> adapter = new TagDefinitionParserAdapter<B>(definitionParser);
        this.lyciaParser.getConfigurator().addTagDefinitionParser(adapter);
        this.parserAdapters.add(adapter);
    }

    public void addTagDefinitionParsers(TagDefinitionParser<B>[] definitionParsers) {
        for (TagDefinitionParser<B> definitionParser : definitionParsers) {
            this.addTagDefinitionParser(definitionParser);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.lyciaParser.getErrorHandler();
    }

    public ParserContext<B> getParserContext() {
        return (ParserContext)this.lyciaParser.getParserContext();
    }

    public ResourceResolver getResourceResolver() {
        org.sourceprojects.lycia.ResourceResolver resolver = this.lyciaParser.getResourceResolver();
        if (resolver instanceof ResourceResolverAdapter) {
            return ((ResourceResolverAdapter)resolver).getWrappedResolver();
        }
        throw new RuntimeException("Found ResourceResolver isn't of type org.sourceprojects.xmlparser.internal.ResourceResolverAdapter");
    }

    public boolean isValidatingSchema() {
        return this.lyciaParser.isValidatingSchema();
    }

    public void parse(Reader reader) throws XmlParserParsingException {
        try {
            this.lyciaParser.parse(reader);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public void parse(String xml) throws XmlParserParsingException {
        try {
            this.lyciaParser.parse(xml);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public void parse(InputStream inputStream) throws XmlParserParsingException {
        try {
            this.lyciaParser.parse(inputStream);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public void parse(File file) throws XmlParserParsingException {
        try {
            this.lyciaParser.parse(file);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        Iterator<ProgressListenerAdapter> iterator = this.listenerAdapters.iterator();
        while (iterator.hasNext()) {
            ProgressListenerAdapter adapter = iterator.next();
            if (adapter.getWrappedListener() != listener) continue;
            this.lyciaParser.removeProgressListener(adapter);
            iterator.remove();
        }
    }

    public void removeTagDefinitionParser(TagDefinitionParser<B> definitionParser) {
        Iterator<TagDefinitionParserAdapter<B>> iterator = this.parserAdapters.iterator();
        while (iterator.hasNext()) {
            TagDefinitionParserAdapter<B> adapter = iterator.next();
            if (adapter.getWrappedTagDefinitionParser() != definitionParser) continue;
            this.lyciaParser.removeTagDefinitionParser(adapter);
            iterator.remove();
        }
    }

    public void removeTagDefinitionParsers(TagDefinitionParser<B>[] definitionParsers) {
        for (TagDefinitionParser<B> definitionParser : definitionParsers) {
            this.removeTagDefinitionParser(definitionParser);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.lyciaParser.setErrorHandler(errorHandler);
    }

    public void setParserContext(ParserContext<B> parserContext) {
        this.lyciaParser.setParserContext((org.sourceprojects.lycia.ParserContext<B>)parserContext);
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.lyciaParser.setResourceResolver(new ResourceResolverAdapter(resourceResolver));
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.lyciaParser.setValidatingSchema(validatingSchema);
    }

    public Document transform(Reader reader) throws XmlParserParsingException {
        try {
            return this.lyciaParser.transform(reader);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public Document transform(String xml) throws XmlParserParsingException {
        try {
            return this.lyciaParser.transform(xml);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public Document transform(InputStream inputStream) throws XmlParserParsingException {
        try {
            return this.lyciaParser.transform(inputStream);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }

    public Document transform(File file) throws XmlParserParsingException {
        try {
            return this.lyciaParser.transform(file);
        }
        catch (LyciaParsingException e) {
            throw new XmlParserParsingException((Throwable)e);
        }
    }
}

