/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.xmlparser.internal.dom;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.sourceprojects.xmlparser.NamespaceResolver;
import org.sourceprojects.xmlparser.ResourceResolver;
import org.sourceprojects.xmlparser.exceptions.XmlParserInitializationException;
import org.sourceprojects.xmlparser.internal.resolver.BasicNamespaceResolver;
import org.sourceprojects.xmlparser.internal.resolver.OsgiBasicNamespaceResolver;
import org.w3c.dom.ls.LSInput;

public class OsgiResourceResolverImpl
implements ResourceResolver {
    private static final Logger LOGGER = Logger.getLogger(OsgiResourceResolverImpl.class.getName());
    private final Map<String, NamespaceResolver> namespaceResolvers = new HashMap<String, NamespaceResolver>();
    private final OsgiBasicNamespaceResolver osgiBasicNamespaceResolver;
    private boolean showWarning = true;

    public OsgiResourceResolverImpl(Bundle bundle) {
        try {
            ArrayList<BasicNamespaceResolver.NamespaceResolverHandlerContainer> containers = new ArrayList<BasicNamespaceResolver.NamespaceResolverHandlerContainer>();
            Enumeration resources = bundle.getResources("META-INF/xmlparser/schema.properties");
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                LOGGER.info("Found schema.properties in '" + url.toString() + "'");
                Properties properties = new Properties();
                properties.load(url.openStream());
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = properties.getProperty(key);
                    containers.add(new BasicNamespaceResolver.NamespaceResolverHandlerContainer(key, value));
                }
            }
            this.osgiBasicNamespaceResolver = new OsgiBasicNamespaceResolver(containers.toArray(new BasicNamespaceResolver.NamespaceResolverHandlerContainer[containers.size()]), bundle);
        }
        catch (IOException e) {
            throw new XmlParserInitializationException("Failed internal initialization", (Throwable)e);
        }
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void registerNamespaceResolver(NamespaceResolver namespaceResolver) {
        String namespaceURI = namespaceResolver.getNamespaceURI();
        if (this.namespaceResolvers.get(namespaceURI) != null && this.isShowWarning()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Namespace ").append(namespaceURI).append(" is already defined and will be overridden.");
            LOGGER.warning(sb.toString());
        }
        this.namespaceResolvers.put(namespaceURI, namespaceResolver);
    }

    public void unregisterNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.unregisterNamespaceResolver(namespaceResolver.getNamespaceURI());
    }

    public void unregisterNamespaceResolver(String namespaceURI) {
        this.namespaceResolvers.remove(namespaceURI);
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        NamespaceResolver resolver = this.namespaceResolvers.get(namespaceURI);
        if (resolver != null) {
            return resolver.getInput(type, namespaceURI, publicId, systemId, baseURI);
        }
        return this.osgiBasicNamespaceResolver.getInput(type, namespaceURI, publicId, systemId, baseURI);
    }
}

