/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.xmlparser.internal.resolver;

import java.io.InputStream;
import org.sourceprojects.xmlparser.NamespaceResolver;
import org.sourceprojects.xmlparser.internal.dom.LSInputImpl;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

public class BasicNamespaceResolver
implements NamespaceResolver {
    private final NamespaceResolverHandlerContainer[] containers;
    private final ClassLoader classLoader;

    public BasicNamespaceResolver(NamespaceResolverHandlerContainer[] containers, ClassLoader classLoader) {
        this.containers = containers;
        this.classLoader = classLoader;
    }

    public LSInput getInput(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        for (NamespaceResolverHandlerContainer container : this.containers) {
            if (!container.getNamespaceURI().equals(namespaceURI) && !container.getNamespaceURI().equals(systemId)) continue;
            InputStream is = this.getByteStream(container.getRedirectedURI());
            LSInputImpl input = new LSInputImpl();
            input.setBaseURI(baseURI);
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setByteStream(is);
            return input;
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)registry.getDOMImplementation("XML").getFeature("LS", "");
            return impl.createLSInput();
        }
        catch (ClassCastException e) {
            return new LSInputImpl();
        }
        catch (ClassNotFoundException e) {
            return new LSInputImpl();
        }
        catch (InstantiationException e) {
            return new LSInputImpl();
        }
        catch (IllegalAccessException e) {
            return new LSInputImpl();
        }
    }

    public String getNamespaceURI() {
        return null;
    }

    private InputStream getByteStream(String uri) {
        return this.classLoader.getResourceAsStream(uri);
    }

    public static class NamespaceResolverHandlerContainer {
        private final String namespaceURI;
        private final String redirectedURI;

        public NamespaceResolverHandlerContainer(String namespaceURI, String redirectedURI) {
            this.namespaceURI = namespaceURI;
            this.redirectedURI = redirectedURI;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getRedirectedURI() {
            return this.redirectedURI;
        }
    }
}

