/*
 * Decompiled with CFR 0.152.
 */
package org.sourceprojects.xmlparser.internal.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.sourceprojects.xmlparser.NamespaceResolver;
import org.sourceprojects.xmlparser.internal.dom.LSInputImpl;
import org.sourceprojects.xmlparser.internal.resolver.BasicNamespaceResolver;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;

public class OsgiBasicNamespaceResolver
implements NamespaceResolver {
    private final BasicNamespaceResolver.NamespaceResolverHandlerContainer[] containers;
    private final Bundle bundle;

    public OsgiBasicNamespaceResolver(BasicNamespaceResolver.NamespaceResolverHandlerContainer[] containers, Bundle bundle) {
        this.containers = containers;
        this.bundle = bundle;
    }

    public LSInput getInput(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        for (BasicNamespaceResolver.NamespaceResolverHandlerContainer container : this.containers) {
            if (!container.getNamespaceURI().equals(namespaceURI) && !container.getNamespaceURI().equals(systemId)) continue;
            InputStream is = this.getByteStream(container.getRedirectedURI());
            LSInputImpl input = new LSInputImpl();
            input.setBaseURI(baseURI);
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setByteStream(is);
            return input;
        }
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)registry.getDOMImplementation("XML").getFeature("LS", "");
            return impl.createLSInput();
        }
        catch (ClassCastException e) {
            return new LSInputImpl();
        }
        catch (ClassNotFoundException e) {
            return new LSInputImpl();
        }
        catch (InstantiationException e) {
            return new LSInputImpl();
        }
        catch (IllegalAccessException e) {
            return new LSInputImpl();
        }
    }

    public String getNamespaceURI() {
        return null;
    }

    private InputStream getByteStream(String uri) {
        URL url = this.bundle.getResource(uri);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }
}

