/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.api.CommonApi;
import com.apicatalog.jsonld.api.ContextApi;
import com.apicatalog.jsonld.api.LoaderApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import java.net.URI;

public final class ExpansionApi
implements CommonApi<ExpansionApi>,
LoaderApi<ExpansionApi>,
ContextApi<ExpansionApi> {
    private final URI documentUri;
    private final Document document;
    private JsonLdOptions options;

    public ExpansionApi(URI documentUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.options = new JsonLdOptions();
    }

    public ExpansionApi(Document document) {
        this.document = document;
        this.documentUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public ExpansionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public ExpansionApi context(URI contextUri) {
        this.options.setExpandContext(contextUri);
        return this;
    }

    @Override
    public ExpansionApi context(String contextLocation) {
        if (contextLocation != null) {
            if (UriUtils.isNotURI(contextLocation)) {
                throw new IllegalArgumentException("Context location must be valid URI or null but is [" + contextLocation + ".");
            }
            return this.context(UriUtils.create(contextLocation));
        }
        return this.context((Document)null);
    }

    @Override
    public ExpansionApi context(JsonStructure context2) {
        this.options.setExpandContext(context2 != null ? JsonDocument.of(context2) : null);
        return this;
    }

    @Override
    public ExpansionApi context(Document context2) {
        this.options.setExpandContext(context2);
        return this;
    }

    @Override
    public ExpansionApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public ExpansionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public ExpansionApi base(String baseLocation) {
        if (baseLocation != null) {
            if (UriUtils.isNotURI(baseLocation)) {
                throw new IllegalArgumentException("Base location must be valid URI or null but is [" + baseLocation + ".");
            }
            return this.base(UriUtils.create(baseLocation));
        }
        return this.base((URI)null);
    }

    @Override
    public ExpansionApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public ExpansionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public JsonArray get() throws JsonLdError {
        if (this.document != null) {
            return ExpansionProcessor.expand(this.document, this.options, false);
        }
        if (this.documentUri != null) {
            return ExpansionProcessor.expand(this.documentUri, this.options);
        }
        throw new IllegalStateException();
    }

    public ExpansionApi numericId() {
        this.options.setNumericId(true);
        return this;
    }

    public ExpansionApi rdfStar() {
        this.options.setRdfStar(true);
        return this;
    }
}

