/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public final class NodeMapBuilder {
    private JsonStructure element;
    private final NodeMap nodeMap;
    private String activeGraph;
    private String activeSubject;
    private String activeProperty;
    private Map<String, JsonValue> referencedNode;
    private Map<String, JsonValue> list;

    private NodeMapBuilder(JsonStructure element, NodeMap nodeMap) {
        this.element = element;
        this.nodeMap = nodeMap;
        this.activeGraph = "@default";
        this.activeSubject = null;
        this.activeProperty = null;
        this.list = null;
        this.referencedNode = null;
    }

    public static final NodeMapBuilder with(JsonStructure element, NodeMap nodeMap) {
        return new NodeMapBuilder(element, nodeMap);
    }

    public NodeMapBuilder activeGraph(String activeGraph) {
        this.activeGraph = activeGraph;
        return this;
    }

    public NodeMapBuilder activeProperty(String activeProperty) {
        this.activeProperty = activeProperty;
        return this;
    }

    public NodeMapBuilder activeSubject(String activeSubject) {
        this.activeSubject = activeSubject;
        return this;
    }

    public NodeMapBuilder list(Map<String, JsonValue> list) {
        this.list = list;
        return this;
    }

    public NodeMapBuilder referencedNode(Map<String, JsonValue> referencedNode) {
        this.referencedNode = referencedNode;
        return this;
    }

    public NodeMap build() throws JsonLdError {
        if (JsonUtils.isArray(this.element)) {
            for (JsonValue item2 : this.element.asJsonArray()) {
                JsonStructure itemValue;
                if (JsonUtils.isObject(item2)) {
                    itemValue = item2.asJsonObject();
                } else if (JsonUtils.isArray(item2)) {
                    itemValue = item2.asJsonArray();
                } else {
                    throw new IllegalStateException();
                }
                NodeMapBuilder.with(itemValue, this.nodeMap).activeGraph(this.activeGraph).activeProperty(this.activeProperty).activeSubject(this.activeSubject).list(this.list).referencedNode(this.referencedNode).build();
            }
            return this.nodeMap;
        }
        LinkedHashMap<String, JsonValue> elementObject = new LinkedHashMap<String, JsonValue>(this.element.asJsonObject());
        if (elementObject.containsKey("@type")) {
            JsonArrayBuilder types = Json.createArrayBuilder();
            JsonUtils.toStream((JsonValue)elementObject.get("@type")).map(item -> JsonUtils.isString(item) && BlankNode.hasPrefix(((JsonString)item).getString()) ? Json.createValue(this.nodeMap.createIdentifier(((JsonString)item).getString())) : item).forEach(types::add);
            elementObject.put("@type", types.build());
        }
        if (elementObject.containsKey("@value")) {
            if (this.list == null) {
                if (this.nodeMap.contains(this.activeGraph, this.activeSubject, this.activeProperty)) {
                    JsonArray activePropertyValue = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty).asJsonArray();
                    if (activePropertyValue.stream().noneMatch(e2 -> Objects.equals(e2, this.element))) {
                        this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder(activePropertyValue).add(this.element).build());
                    }
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder().add(JsonUtils.toJsonObject(elementObject)).build());
                }
            } else {
                this.list.put("@list", Json.createArrayBuilder(this.list.get("@list").asJsonArray()).add(this.element).build());
            }
        } else if (elementObject.containsKey("@list")) {
            LinkedHashMap<String, JsonValue> result = new LinkedHashMap<String, JsonValue>();
            result.put("@list", JsonValue.EMPTY_JSON_ARRAY);
            NodeMapBuilder.with((JsonStructure)elementObject.get("@list"), this.nodeMap).activeGraph(this.activeGraph).activeSubject(this.activeSubject).activeProperty(this.activeProperty).referencedNode(this.referencedNode).list(result).build();
            if (this.list == null) {
                if (this.nodeMap.contains(this.activeGraph, this.activeSubject, this.activeProperty)) {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder(this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty).asJsonArray()).add(JsonUtils.toJsonObject(result)).build());
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder().add(JsonUtils.toJsonObject(result)).build());
                }
            } else {
                this.list.put("@list", Json.createArrayBuilder(this.list.get("@list").asJsonArray()).add(JsonUtils.toJsonObject(result)).build());
            }
        } else if (NodeObject.isNodeObject(this.element)) {
            String id = null;
            if (elementObject.containsKey("@id")) {
                if (JsonUtils.isNotString((JsonValue)elementObject.get("@id")) || JsonUtils.isNull((JsonValue)elementObject.get("@id"))) {
                    return this.nodeMap;
                }
                id = ((JsonString)elementObject.get("@id")).getString();
                if (BlankNode.hasPrefix(id)) {
                    id = this.nodeMap.createIdentifier(id);
                }
                elementObject.remove("@id");
            } else {
                id = this.nodeMap.createIdentifier();
            }
            if (id != null && !this.nodeMap.contains(this.activeGraph, id)) {
                this.nodeMap.set(this.activeGraph, id, "@id", Json.createValue(id));
            }
            if (this.referencedNode != null) {
                if (this.nodeMap.contains(this.activeGraph, id, this.activeProperty)) {
                    JsonArray activePropertyValue = this.nodeMap.get(this.activeGraph, id, this.activeProperty).asJsonArray();
                    if (activePropertyValue.stream().noneMatch(e2 -> Objects.equals(e2, JsonUtils.toJsonObject(this.referencedNode)))) {
                        this.nodeMap.set(this.activeGraph, id, this.activeProperty, Json.createArrayBuilder(activePropertyValue).add(JsonUtils.toJsonObject(this.referencedNode)).build());
                    }
                } else {
                    this.nodeMap.set(this.activeGraph, id, this.activeProperty, Json.createArrayBuilder().add(JsonUtils.toJsonObject(this.referencedNode)).build());
                }
            } else if (this.activeProperty != null) {
                JsonObject reference = Json.createObjectBuilder().add("@id", id).build();
                if (this.list == null) {
                    if (this.nodeMap.contains(this.activeGraph, this.activeSubject, this.activeProperty)) {
                        JsonArray activePropertyValue = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty).asJsonArray();
                        if (activePropertyValue.stream().noneMatch(e2 -> Objects.equals(e2, reference))) {
                            this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder(activePropertyValue).add(reference).build());
                        }
                    } else {
                        this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, Json.createArrayBuilder().add(reference).build());
                    }
                } else {
                    this.list.put("@list", Json.createArrayBuilder(this.list.get("@list").asJsonArray()).add(reference).build());
                }
            }
            if (elementObject.containsKey("@type")) {
                LinkedHashSet<Object> nodeType = new LinkedHashSet<Object>();
                JsonValue nodeTypeValue = this.nodeMap.get(this.activeGraph, id, "@type");
                if (JsonUtils.isArray(nodeTypeValue)) {
                    nodeTypeValue.asJsonArray().stream().filter(JsonUtils::isNotNull).forEach(nodeType::add);
                } else if (JsonUtils.isNotNull(nodeTypeValue)) {
                    nodeType.add(nodeTypeValue);
                }
                JsonValue typeValue = (JsonValue)elementObject.get("@type");
                if (JsonUtils.isArray(typeValue)) {
                    typeValue.asJsonArray().stream().filter(JsonUtils::isNotNull).forEach(nodeType::add);
                } else if (JsonUtils.isNotNull(typeValue)) {
                    nodeType.add(typeValue);
                }
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                nodeType.forEach(jsonArrayBuilder::add);
                this.nodeMap.set(this.activeGraph, id, "@type", jsonArrayBuilder.build());
                elementObject.remove("@type");
            }
            if (elementObject.containsKey("@index")) {
                if (this.nodeMap.contains(this.activeGraph, id, "@index")) {
                    throw new JsonLdError(JsonLdErrorCode.CONFLICTING_INDEXES);
                }
                this.nodeMap.set(this.activeGraph, id, "@index", (JsonValue)elementObject.get("@index"));
                elementObject.remove("@index");
            }
            if (elementObject.containsKey("@reverse")) {
                LinkedHashMap<String, JsonValue> referenced = new LinkedHashMap<String, JsonValue>();
                referenced.put("@id", Json.createValue(id));
                JsonValue reverseMap = (JsonValue)elementObject.get("@reverse");
                for (Map.Entry entry : reverseMap.asJsonObject().entrySet()) {
                    for (JsonValue value : ((JsonValue)entry.getValue()).asJsonArray()) {
                        NodeMapBuilder.with((JsonStructure)value, this.nodeMap).activeGraph(this.activeGraph).referencedNode(referenced).activeProperty((String)entry.getKey()).build();
                    }
                }
                elementObject.remove("@reverse");
            }
            if (elementObject.containsKey("@graph")) {
                NodeMapBuilder.with((JsonStructure)elementObject.get("@graph"), this.nodeMap).activeGraph(id).build();
                elementObject.remove("@graph");
            }
            if (elementObject.containsKey("@included")) {
                NodeMapBuilder.with((JsonStructure)elementObject.get("@included"), this.nodeMap).activeGraph(this.activeGraph).build();
                elementObject.remove("@included");
            }
            for (String property : Utils.index(elementObject.keySet(), true)) {
                JsonValue value = (JsonValue)elementObject.get(property);
                if (value == null || !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType()) && !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType())) continue;
                if (BlankNode.hasPrefix(property)) {
                    property = this.nodeMap.createIdentifier(property);
                }
                if (!this.nodeMap.contains(this.activeGraph, id, property)) {
                    this.nodeMap.set(this.activeGraph, id, property, JsonValue.EMPTY_JSON_ARRAY);
                }
                NodeMapBuilder.with((JsonStructure)value, this.nodeMap).activeGraph(this.activeGraph).activeSubject(id).activeProperty(property).referencedNode(this.referencedNode).build();
            }
        }
        return this.nodeMap;
    }
}

