/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.Validate;

public class ClassPathUtils {
    public static String toFullyQualifiedName(Class<?> context2, String resourceName) {
        Validate.notNull(context2, "Parameter '%s' must not be null!", "context");
        Validate.notNull(resourceName, "Parameter '%s' must not be null!", "resourceName");
        return ClassPathUtils.toFullyQualifiedName(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedName(Package context2, String resourceName) {
        Validate.notNull(context2, "Parameter '%s' must not be null!", "context");
        Validate.notNull(resourceName, "Parameter '%s' must not be null!", "resourceName");
        return context2.getName() + "." + resourceName;
    }

    public static String toFullyQualifiedPath(Class<?> context2, String resourceName) {
        Validate.notNull(context2, "Parameter '%s' must not be null!", "context");
        Validate.notNull(resourceName, "Parameter '%s' must not be null!", "resourceName");
        return ClassPathUtils.toFullyQualifiedPath(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedPath(Package context2, String resourceName) {
        Validate.notNull(context2, "Parameter '%s' must not be null!", "context");
        Validate.notNull(resourceName, "Parameter '%s' must not be null!", "resourceName");
        return context2.getName().replace('.', '/') + "/" + resourceName;
    }
}

