/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;

public class PipedRDFIterator<T>
implements Iterator<T>,
Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 10000;
    public static final int DEFAULT_POLL_TIMEOUT = 1000;
    public static final int DEFAULT_MAX_POLLS = 10;
    private final BlockingQueue<T> queue;
    private final T endMarker = new Object();
    private volatile boolean closedByConsumer = false;
    private volatile boolean closedByProducer = false;
    private volatile boolean finished = false;
    private volatile boolean threadReused = false;
    private volatile Thread consumerThread;
    private volatile Thread producerThread;
    private boolean connected = false;
    private int pollTimeout = 1000;
    private int maxPolls = 10;
    private T slot;
    private final Object lock = new Object();
    private String baseIri;
    private final PrefixMap prefixes = PrefixMapFactory.create();

    public PipedRDFIterator() {
        this(10000);
    }

    public PipedRDFIterator(int bufferSize) {
        this(bufferSize, false, 1000, 10);
    }

    public PipedRDFIterator(int bufferSize, boolean fair) {
        this(bufferSize, fair, 1000, 10);
    }

    public PipedRDFIterator(int bufferSize, boolean fair, int pollTimeout, int maxPolls) {
        if (pollTimeout <= 0) {
            throw new IllegalArgumentException("Poll Timeout must be > 0");
        }
        if (maxPolls <= 0) {
            throw new IllegalArgumentException("Max Poll attempts must be > 0");
        }
        this.queue = new ArrayBlockingQueue<T>(bufferSize, fair);
        this.pollTimeout = pollTimeout;
        this.maxPolls = maxPolls;
    }

    @Override
    public boolean hasNext() {
        block11: {
            if (!this.connected) {
                throw new IllegalStateException("Pipe not connected");
            }
            if (this.closedByConsumer) {
                throw new RiotException("Pipe closed");
            }
            if (this.finished) {
                return false;
            }
            this.consumerThread = Thread.currentThread();
            if (this.producerThread != null && this.producerThread == this.consumerThread) {
                this.threadReused = true;
            }
            if (this.slot != null) {
                return true;
            }
            int attempts = 0;
            do {
                ++attempts;
                try {
                    this.slot = this.queue.poll(this.pollTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e2) {
                    throw new CancellationException();
                }
                if (null != this.slot) break block11;
                if (this.threadReused || this.producerThread != null && !this.producerThread.isAlive() && !this.closedByProducer) {
                    this.closedByConsumer = true;
                    throw new RiotException("Producer dead");
                }
                if (!this.closedByConsumer) continue;
                throw new RiotException("Pipe closed");
            } while (attempts < this.maxPolls);
            this.closedByConsumer = true;
            if (this.producerThread != null) {
                throw new RiotException("Producer failed to produce any data within the specified number of polling attempts, declaring producer dead");
            }
            throw new RiotException("Producer failed to ever call start(), declaring producer dead");
        }
        if (this.slot == this.endMarker) {
            this.finished = true;
            this.slot = null;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.slot;
        this.slot = null;
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void checkStateForReceive() {
        if (this.closedByProducer || this.closedByConsumer) {
            throw new RiotException("Pipe closed");
        }
        if (this.consumerThread != null && !this.consumerThread.isAlive()) {
            throw new RiotException("Consumer dead");
        }
    }

    protected void connect() {
        this.connected = true;
    }

    protected void receive(T t) {
        this.checkStateForReceive();
        this.producerThread = Thread.currentThread();
        try {
            this.queue.put(t);
        }
        catch (InterruptedException e2) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void base(String base) {
        Object object = this.lock;
        synchronized (object) {
            this.baseIri = base;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseIri() {
        Object object = this.lock;
        synchronized (object) {
            return this.baseIri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prefix(String prefix, String iri) {
        Object object = this.lock;
        synchronized (object) {
            this.prefixes.add(prefix, iri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrefixMap getPrefixes() {
        Object object = this.lock;
        synchronized (object) {
            return PrefixMapFactory.create(this.prefixes);
        }
    }

    protected void start() {
        this.producerThread = Thread.currentThread();
    }

    protected void finish() {
        if (this.closedByProducer) {
            return;
        }
        this.receive(this.endMarker);
        this.closedByProducer = true;
    }

    @Override
    public void close() {
        this.closedByConsumer = true;
    }
}

