/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.extra;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.extra.LangParserLib;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.vocabulary.RDF;

public class LangParserBase {
    protected final Node XSD_TRUE = NodeConst.nodeTrue;
    protected final Node XSD_FALSE = NodeConst.nodeFalse;
    protected final Node nRDFtype = NodeConst.nodeRDFType;
    protected final Node nRDFnil = NodeConst.nodeNil;
    protected final Node nRDFfirst = NodeConst.nodeFirst;
    protected final Node nRDFrest = NodeConst.nodeRest;
    protected final Node nRDFsubject = RDF.Nodes.subject;
    protected final Node nRDFpredicate = RDF.Nodes.predicate;
    protected final Node nRDFobject = RDF.Nodes.object;
    protected StreamRDF stream;
    protected ParserProfile profile;

    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public void setDest(StreamRDF stream) {
        this.stream = stream;
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected Node createURI(String iriStr, int line, int column) {
        return this.profile.createURI(iriStr, line, column);
    }

    protected Node createBNode(int line, int column) {
        return this.profile.createBlankNode(null, line, column);
    }

    protected Node createBNode(String label, int line, int column) {
        return this.profile.createBlankNode(null, label, line, column);
    }

    protected Node createListNode(int line, int column) {
        return this.createBNode(line, column);
    }

    protected void checkString(String string, int line, int column) {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isHighSurrogate(ch)) {
                if (++i == string.length()) {
                    throw new RiotParseException("Bad surrogate pair (end of string)", line, column);
                }
                char ch1 = string.charAt(i);
                if (Character.isLowSurrogate(ch1)) continue;
                throw new RiotParseException("Bad surrogate pair (high surrogate not followed by low surrogate)", line, column);
            }
            if (!Character.isLowSurrogate(ch)) continue;
            throw new RiotParseException("Bad surrogate pair (low surrogate without high surrogate)", line, column);
        }
    }

    protected Node createLiteral(String lexicalForm, String langTag, String datatypeURI, int line, int column) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = this.profile.createTypedLiteral(lexicalForm, dType, line, column);
        } else {
            n = langTag != null && !langTag.isEmpty() ? this.profile.createLangLiteral(lexicalForm, langTag, line, column) : this.profile.createStringLiteral(lexicalForm, line, column);
        }
        return n;
    }

    protected Node createTripleTerm(Node s, Node p, Node o, int line, int column) {
        return this.profile.createTripleNode(s, p, o, line, column);
    }

    protected Node createLiteralInteger(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, XSDDatatype.XSDinteger, line, column);
    }

    protected Node createLiteralDecimal(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, XSDDatatype.XSDdecimal, line, column);
    }

    protected Node createLiteralDouble(String lexicalForm, int line, int column) {
        return this.profile.createTypedLiteral(lexicalForm, XSDDatatype.XSDdouble, line, column);
    }

    protected Var createVariable(String varName, int line, int column) {
        varName = varName.substring(1);
        return Var.alloc(varName);
    }

    protected String resolvePName(String pname, int line, int column) {
        String expansion;
        int idx = pname.indexOf(58);
        String prefix = pname.substring(0, idx);
        String localPart = pname.substring(idx + 1);
        if ((localPart = LangParserLib.unescapePName(localPart, line, column)).contains("\\")) {
            System.out.println("X");
        }
        if ((expansion = this.profile.getPrefixMap().expand(prefix, localPart)) == null) {
            if (ARQ.isTrue(ARQ.fixupUndefinedPrefixes)) {
                return RiotLib.fixupPrefixIRI(prefix, localPart);
            }
            this.profile.getErrorHandler().fatal("Undefined prefix: " + prefix, line, column);
        }
        return expansion;
    }

    protected String resolveQuotedIRI(String iriStr, int line, int column) {
        iriStr = LangParserLib.stripQuotes(iriStr);
        if ((iriStr = this.unescapeIRI(iriStr)).contains("<") || iriStr.contains(">")) {
            throw new RiotParseException("Illegal character '<' or '>' in IRI: '" + iriStr + "'", line, column);
        }
        return this.profile.resolveIRI(iriStr, line, column);
    }

    protected void setBase(String iri, int line, int column) {
        this.profile.setBaseIRI(iri);
        this.stream.base(iri);
    }

    protected void setPrefix(String prefix, String iri, int line, int column) {
        prefix = this.fixupPrefix(prefix, line, column);
        this.profile.getPrefixMap().add(prefix, iri);
        this.stream.prefix(prefix, iri);
    }

    protected void emitTriple(int line, int column, Node s, Node p, Node o) {
        this.stream.triple(Triple.create(s, p, o));
    }

    protected String unescapeIRI(String iriStr) {
        try {
            return EscapeStr.unescape(iriStr, '\\', true);
        }
        catch (AtlasException ex) {
            throw new RiotException(ex.getMessage());
        }
    }

    protected void listStart(int line, int column) {
    }

    protected void listTriple(int line, int column, Node s, Node p, Node o) {
        this.emitTriple(line, column, s, p, o);
    }

    protected void listFinish(int line, int column) {
    }
}

