/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.RdfDocument;
import com.apicatalog.rdf.RdfDataset;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.JenaTitanium;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class JsonLD11Writer
implements WriterDatasetRIOT {
    private static Map<String, ?> configPretty = Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    private static Map<String, ?> configFlat = Map.of();
    private final RDFFormat format;

    public JsonLD11Writer(RDFFormat format) {
        this.format = format;
    }

    private Map<String, ?> config() {
        return this.format == RDFFormat.JSONLD11_PLAIN ? configPretty : configFlat;
    }

    @Override
    public void write(OutputStream outputStream, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(datasetGraph);
        this.write$(outputStream, null, datasetGraph);
    }

    @Override
    public void write(Writer out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(datasetGraph);
        this.write$(null, out, datasetGraph);
    }

    @Override
    public Lang getLang() {
        return Lang.JSONLD;
    }

    private void write$(OutputStream output, Writer writer, DatasetGraph dsg) {
        try {
            RdfDataset ds = JenaTitanium.convert(dsg);
            Document doc = RdfDocument.of(ds);
            JsonArray array = JsonLd.fromRdf(doc).get();
            JsonStructure writeThis = null;
            writeThis = Json.createObjectBuilder().add("@context", Json.createObjectBuilder().add("@version", 1.1)).add("@graph", array).build();
            if (writeThis == null) {
                writeThis = array;
            }
            JsonWriter jsonWriter = this.startWrite(output, writer);
            jsonWriter.write(writeThis);
            this.finishWrite(output, writer);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return;
        }
    }

    private JsonWriter startWrite(OutputStream output, Writer writer) {
        Map<String, ?> config = this.config();
        JsonWriterFactory factory = Json.createWriterFactory(config);
        return output != null ? factory.createWriter(output) : factory.createWriter(writer);
    }

    private void finishWrite(OutputStream output, Writer writer) throws IOException {
        boolean outputNL;
        boolean bl = outputNL = this.format != RDFFormat.JSONLD11_FLAT;
        if (output != null) {
            if (outputNL) {
                output.write(10);
            }
            output.flush();
        } else {
            if (outputNL) {
                writer.write("\n");
            }
            writer.flush();
        }
    }
}

