/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class BaseXSSFFormulaEvaluator
extends BaseFormulaEvaluator {
    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        super(bookEvaluator);
    }

    @Override
    protected RichTextString createRichTextString(String str2) {
        return new XSSFRichTextString(str2);
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    @Override
    protected CellValue evaluateFormulaCellValue(Cell cell) {
        EvaluationCell evalCell = this.toEvaluationCell(cell);
        ValueEval eval2 = this._bookEvaluator.evaluate(evalCell);
        if (eval2 instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval2;
            return new CellValue(ne.getNumberValue());
        }
        if (eval2 instanceof BoolEval) {
            BoolEval be = (BoolEval)eval2;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval2 instanceof StringEval) {
            StringEval ne = (StringEval)eval2;
            return new CellValue(ne.getStringValue());
        }
        if (eval2 instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval2).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval2.getClass().getName() + ")");
    }

    @Override
    protected void setCellType(Cell cell, CellType cellType) {
        if (cell instanceof XSSFCell) {
            EvaluationWorkbook evaluationWorkbook = this.getEvaluationWorkbook();
            BaseXSSFEvaluationWorkbook xewb = BaseXSSFEvaluationWorkbook.class.isAssignableFrom(evaluationWorkbook.getClass()) ? (BaseXSSFEvaluationWorkbook)evaluationWorkbook : null;
            ((XSSFCell)cell).setCellType(cellType, xewb);
        } else {
            cell.setCellType(cellType);
        }
    }
}

