/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;

public class BomParserFactory {
    private BomParserFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Parser createParser(File file) throws ParseException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = IOUtils.toByteArray((InputStream)fis, 1);
            Parser parser = BomParserFactory.createParser(bytes);
            return parser;
        }
        catch (IOException e2) {
            throw new ParseException("An error occurred creating parser from file", e2);
        }
    }

    public static Parser createParser(byte[] bytes) throws ParseException {
        if (bytes[0] == 123) {
            return new JsonParser();
        }
        if (bytes[0] == 60) {
            return new XmlParser();
        }
        throw new ParseException("The specified BOM is not in a supported format. Supported formats are XML and JSON");
    }

    public static boolean looksLikeCycloneDX(byte[] bytes) {
        String bomString = new String(bytes, StandardCharsets.UTF_8);
        if (bomString.startsWith("<?xml") && bomString.contains("<bom") && bomString.contains("http://cyclonedx.org/schema/bom")) {
            return true;
        }
        return bomString.startsWith("{") && bomString.contains("bomFormat") && bomString.contains("CycloneDX");
    }
}

