/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.ServiceData;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.LicenseDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"provider", "group", "name", "version", "description", "endpoints", "authenticated", "xTrustBoundary", "data", "licenses", "externalReferences", "properties", "services"})
public class Service
extends ExtensibleElement {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    private OrganizationalEntity provider;
    private String group;
    private String name;
    private String version;
    private String description;
    private List<String> endpoints;
    private Boolean authenticated;
    @JacksonXmlProperty(localName="x-trust-boundary")
    @JsonProperty(value="x-trust-boundary")
    private Boolean xTrustBoundary;
    private List<ServiceData> data;
    private LicenseChoice license;
    private List<ExternalReference> externalReferences;
    @VersionFilter(versions={"1.3"})
    private List<Property> properties;
    private List<Service> services;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public OrganizationalEntity getProvider() {
        return this.provider;
    }

    public void setProvider(OrganizationalEntity provider) {
        this.provider = provider;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JacksonXmlElementWrapper(localName="endpoints")
    @JacksonXmlProperty(localName="endpoint")
    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(String endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(endpoint);
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public Boolean getxTrustBoundary() {
        return this.xTrustBoundary;
    }

    public void setxTrustBoundary(Boolean xTrustBoundary) {
        this.xTrustBoundary = xTrustBoundary;
    }

    @JacksonXmlElementWrapper(localName="data")
    @JacksonXmlProperty(localName="classification")
    public List<ServiceData> getData() {
        return this.data;
    }

    public void addServiceData(ServiceData data) {
        if (this.data == null) {
            this.data = new ArrayList<ServiceData>();
        }
        this.data.add(data);
    }

    public void setData(List<ServiceData> data) {
        this.data = data;
    }

    @JacksonXmlProperty(localName="licenses")
    @JsonProperty(value="licenses")
    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicense() {
        return this.license;
    }

    public void setLicense(LicenseChoice license) {
        this.license = license;
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="reference")
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }
}

