/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.util.Arrays;
import org.cyclonedx.model.Ancestors;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ComponentWrapper;
import org.cyclonedx.model.Descendants;
import org.cyclonedx.model.Variants;

public class ComponentWrapperDeserializer
extends JsonDeserializer<ComponentWrapper> {
    private static final String ANCESTORS = "ancestors";
    private static final String DESCENDANTS = "descendants";
    private static final String VARIANTS = "variants";

    @Override
    public ComponentWrapper deserialize(JsonParser parser, DeserializationContext context2) throws IOException {
        ComponentWrapper wrapper;
        String location = parser.getCurrentName();
        if (parser instanceof FromXmlParser) {
            switch (location) {
                case "ancestors": {
                    return parser.readValueAs(Ancestors.class);
                }
                case "descendants": {
                    return parser.readValueAs(Descendants.class);
                }
                case "variants": {
                    return parser.readValueAs(Variants.class);
                }
            }
            return null;
        }
        switch (location) {
            case "ancestors": {
                wrapper = new Ancestors();
                break;
            }
            case "descendants": {
                wrapper = new Descendants();
                break;
            }
            case "variants": {
                wrapper = new Variants();
                break;
            }
            default: {
                return null;
            }
        }
        Component[] components = parser.readValueAs(Component[].class);
        wrapper.setComponents(Arrays.asList(components));
        return wrapper;
    }
}

