/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.jacksonstore.JacksonDeSerializer;
import org.spdx.jacksonstore.JacksonSerializer;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.ExtendedSpdxStore;

public class MultiFormatStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger(MultiFormatStore.class);
    private Format format;
    private Verbose verbose;
    static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    static final ObjectMapper XML_MAPPER = new XmlMapper().configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true).enable(SerializationFeature.INDENT_OUTPUT);
    static final YAMLFactory yamlFactory = new YAMLFactory();
    static final ObjectMapper YAML_MAPPER = new ObjectMapper(yamlFactory);
    static final XmlFactory xmlFactory = new XmlFactory();
    private ObjectMapper outputMapper;
    private ObjectMapper inputMapper;

    public MultiFormatStore(IModelStore baseStore, Format format, Verbose verbose) {
        super(baseStore);
        Objects.requireNonNull(format);
        Objects.requireNonNull(verbose);
        this.format = format;
        this.verbose = verbose;
        this.setMapper();
    }

    private void setMapper() {
        switch (this.format) {
            case XML: {
                this.outputMapper = XML_MAPPER;
                this.inputMapper = JSON_MAPPER;
                break;
            }
            case YAML: {
                this.outputMapper = YAML_MAPPER;
                this.inputMapper = YAML_MAPPER;
                break;
            }
            default: {
                this.outputMapper = JSON_MAPPER;
                this.inputMapper = JSON_MAPPER;
            }
        }
    }

    public MultiFormatStore(IModelStore baseStore, Format format) {
        this(baseStore, format, Verbose.COMPACT);
    }

    public synchronized Format getFormat() {
        return this.format;
    }

    public synchronized void setFormat(Format format) {
        Objects.requireNonNull(format);
        this.format = format;
        this.setMapper();
    }

    public synchronized Verbose getVerbose() {
        return this.verbose;
    }

    public synchronized void setVerbose(Verbose verbose) {
        Objects.requireNonNull(verbose);
        this.verbose = verbose;
        this.setMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void serialize(String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        JacksonSerializer serializer = new JacksonSerializer(this.outputMapper, this.format, this.verbose, this);
        ObjectNode output = serializer.docToJsonNode(documentUri);
        JsonGenerator jgen = null;
        try {
            switch (this.format) {
                case YAML: {
                    jgen = yamlFactory.createGenerator(stream);
                    break;
                }
                case XML: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream).useDefaultPrettyPrinter();
                    break;
                }
                case JSON: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream);
                    break;
                }
                default: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream).useDefaultPrettyPrinter();
                }
            }
            this.outputMapper.writeTree(jgen, output);
        }
        finally {
            if (Objects.nonNull(jgen)) {
                jgen.close();
            }
        }
    }

    public static String propertyNameToCollectionPropertyName(String propertyName) {
        if (propertyName.endsWith("y")) {
            return propertyName.substring(0, propertyName.length() - 1) + "ies";
        }
        if ("licenseInfoFromFiles".equals(propertyName)) {
            return propertyName;
        }
        return propertyName + "s";
    }

    public static String collectionPropertyNameToPropertyName(String collectionPropertyName) {
        if (collectionPropertyName.endsWith("ies")) {
            return collectionPropertyName.substring(0, collectionPropertyName.length() - 3) + "y";
        }
        if ("licenseInfoFromFiles".equals(collectionPropertyName)) {
            return collectionPropertyName;
        }
        return collectionPropertyName.substring(0, collectionPropertyName.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        JsonNode doc;
        Objects.requireNonNull(stream, "Input stream must not be null");
        if (this.verbose != Verbose.COMPACT) {
            throw new InvalidSPDXAnalysisException("Only COMPACT verbose option is supported for deserialization");
        }
        if (Format.XML.equals((Object)this.format)) {
            JSONObject jo = XML.toJSONObject(new InputStreamReader(stream, "UTF-8"));
            doc = this.inputMapper.readTree(jo.toString()).get("Document");
        } else {
            doc = this.inputMapper.readTree(stream);
        }
        if (Objects.isNull(doc)) {
            throw new InvalidSPDXAnalysisException("Missing SPDX Document");
        }
        JsonNode namespaceNode = doc.get("documentNamespace");
        if (Objects.isNull(namespaceNode)) {
            throw new InvalidSPDXAnalysisException("Missing document namespace");
        }
        String documentNamespace = namespaceNode.asText();
        if (Objects.isNull(documentNamespace) || documentNamespace.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Empty document namespace");
        }
        if (this.getDocumentUris().contains(documentNamespace)) {
            IModelStore.IModelStoreLock lock = this.enterCriticalSection(documentNamespace, false);
            try {
                if (!overwrite) {
                    throw new InvalidSPDXAnalysisException("Document namespace " + documentNamespace + " already exists.");
                }
                this.clear(documentNamespace);
            }
            finally {
                this.leaveCriticalSection(lock);
            }
        }
        JacksonDeSerializer deSerializer = new JacksonDeSerializer(this, this.format);
        deSerializer.storeDocument(documentNamespace, doc);
        return documentNamespace;
    }

    public static enum Format {
        JSON,
        JSON_PRETTY,
        XML,
        YAML;

    }

    public static enum Verbose {
        COMPACT,
        STANDARD,
        FULL;

    }
}

