/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.storage.IModelStore;

public class ExternalDocumentRef
extends ModelObject
implements Comparable<ExternalDocumentRef> {
    public static Optional<ExternalDocumentRef> getExternalDocRefByDocNamespace(IModelStore stModelStore, String stDocumentUri, String externalDocUri, @Nullable ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(stModelStore, "Model store can not be null");
        Objects.requireNonNull(stDocumentUri, "Document URI can not be null");
        Objects.requireNonNull(externalDocUri, "External document URI can not be null");
        IModelStore.IModelStoreLock lock = stModelStore.enterCriticalSection(stDocumentUri, false);
        try {
            ModelCollection existingExternalRefs = new ModelCollection(stModelStore, stDocumentUri, "SPDXRef-DOCUMENT", "externalDocumentRef", copyManager, ExternalDocumentRef.class);
            for (Object externalRef : existingExternalRefs) {
                if (!(externalRef instanceof ExternalDocumentRef)) {
                    logger.warn("Incorrect type for an external document ref: " + externalRef.getClass().toString());
                    continue;
                }
                String externalRefNamespace = ((ExternalDocumentRef)externalRef).getSpdxDocumentNamespace();
                if (externalRefNamespace.isEmpty()) {
                    logger.warn("Namespace missing for external doc ref " + ((ExternalDocumentRef)externalRef).getId());
                }
                if (!externalDocUri.equals(externalRefNamespace)) continue;
                Optional<ExternalDocumentRef> optional = Optional.of((ExternalDocumentRef)externalRef);
                return optional;
            }
            if (Objects.nonNull(copyManager)) {
                ExternalDocumentRef retval = new ExternalDocumentRef(stModelStore, stDocumentUri, stModelStore.getNextId(IModelStore.IdType.DocumentRef, stDocumentUri), copyManager, true);
                retval.setSpdxDocumentNamespace(externalDocUri);
                ModelObject.addValueToCollection(stModelStore, stDocumentUri, "SPDXRef-DOCUMENT", "externalDocumentRef", retval, copyManager);
                Optional<ExternalDocumentRef> optional = Optional.of(retval);
                return optional;
            }
            Optional<ExternalDocumentRef> optional = Optional.empty();
            return optional;
        }
        finally {
            stModelStore.leaveCriticalSection(lock);
        }
    }

    public ExternalDocumentRef() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.DocumentRef, DefaultModelStore.getDefaultDocumentUri()));
    }

    public ExternalDocumentRef(String id) throws InvalidSPDXAnalysisException {
        super(id);
        if (!SpdxVerificationHelper.isValidExternalDocRef(id)) {
            logger.warn("Invalid external document reference ID " + id + ".  Must be of the format " + SpdxConstants.EXTERNAL_DOC_REF_PATTERN.pattern());
        }
    }

    public ExternalDocumentRef(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!SpdxVerificationHelper.isValidExternalDocRef(id)) {
            logger.warn("Invalid external document reference ID " + id + ".  Must be of the format " + SpdxConstants.EXTERNAL_DOC_REF_PATTERN.pattern());
        }
    }

    @Override
    public String getType() {
        return "ExternalDocumentRef";
    }

    private String documentToDocumentUri(SpdxDocument document) {
        Objects.requireNonNull(document, "Document can not be null");
        String retval = document.getDocumentUri();
        if (retval.endsWith("#")) {
            retval = retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    public Optional<Checksum> getChecksum() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValue("checksum");
    }

    public ExternalDocumentRef setChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(checksum)) {
                throw new InvalidSPDXAnalysisException("Null value for a required checksum");
            }
            List<String> verify = checksum.verify(new ArrayList<String>(), "SPDX-2.3");
            if (verify.size() > 0) {
                throw new InvalidSPDXAnalysisException("Invalid checksum: " + verify.get(0));
            }
        }
        this.setPropertyValue("checksum", checksum);
        return this;
    }

    public String getSpdxDocumentNamespace() throws InvalidSPDXAnalysisException {
        Optional<Object> docNamespace = this.getObjectPropertyValue("spdxDocument");
        if (!docNamespace.isPresent()) {
            logger.warn("SPDX document namespace not found");
            return "";
        }
        if (docNamespace.get() instanceof IndividualUriValue) {
            String docUri = ((IndividualUriValue)docNamespace.get()).getIndividualURI();
            if (Objects.isNull(docUri)) {
                logger.warn("Missing individual URI in doc namespace");
                return "";
            }
            return docUri;
        }
        if (docNamespace.get() instanceof String) {
            logger.warn("Spdx Document Namespace is of type literal string.  Reccomended type is IndividualValue");
            return (String)docNamespace.get();
        }
        logger.error("SPDX document namespace is not of type IndividualValue or String.  Type=" + docNamespace.get().getClass().toString());
        throw new SpdxInvalidTypeException("SPDX document namespace is not of type IndividualValue or String");
    }

    public ExternalDocumentRef setSpdxDocumentNamespace(final String documentNamespace) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(documentNamespace)) {
            if (this.strict) {
                throw new InvalidSPDXAnalysisException("Null value for a required docment namespace");
            }
            this.setPropertyValue("spdxDocument", null);
        } else {
            if (this.strict && !SpdxVerificationHelper.isValidUri(documentNamespace)) {
                throw new InvalidSPDXAnalysisException("Invalid document namespace.  Must be a valid URI.");
            }
            this.setPropertyValue("spdxDocument", new IndividualUriValue(){

                @Override
                public String getIndividualURI() {
                    return documentNamespace;
                }
            });
        }
        return this;
    }

    public Optional<SpdxDocument> getSpdxDocument() throws InvalidSPDXAnalysisException {
        String docNamespace = this.getSpdxDocumentNamespace();
        if (docNamespace.isEmpty()) {
            return Optional.empty();
        }
        if (this.getModelStore().exists(docNamespace, "SPDXRef-DOCUMENT")) {
            return Optional.of(SpdxModelFactory.createModelObject(this.getModelStore(), docNamespace, "SPDXRef-DOCUMENT", "SpdxDocument", this.getCopyManager()));
        }
        return Optional.empty();
    }

    public ExternalDocumentRef setSpdxDocument(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        this.setSpdxDocumentNamespace(this.documentToDocumentUri(spdxDocument));
        return this;
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.getId().startsWith(SpdxConstants.EXTERNAL_DOC_REF_PRENUM)) {
            retval.add("Invalid external ref ID: " + this.getId() + ".  Must start with " + SpdxConstants.EXTERNAL_DOC_REF_PRENUM + ".");
        }
        String spdxDocumentNamespace = "UNKNOWN";
        try {
            spdxDocumentNamespace = this.getSpdxDocumentNamespace();
            if (spdxDocumentNamespace.isEmpty()) {
                retval.add("Missing required external document URI");
            } else if (!SpdxVerificationHelper.isValidUri(spdxDocumentNamespace)) {
                retval.add("Invalid URI for external Spdx Document URI: " + spdxDocumentNamespace);
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("error getting document namespace", e2);
            retval.add("Error getting document namespace");
        }
        try {
            Optional<Checksum> checksum = this.getChecksum();
            if (!checksum.isPresent()) {
                retval.add("Missing checksum for external document " + this.getId());
            } else {
                retval.addAll(checksum.get().verify(verifiedIds, "SPDX-2.3"));
                if (checksum.get().getAlgorithm() != ChecksumAlgorithm.SHA1) {
                    retval.add("Checksum algorithm is not SHA1 for external reference " + this.getId());
                }
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.error("error getting checksum", e3);
            retval.add("Error getting checksum for " + this.getId());
        }
        return retval;
    }

    @Override
    public int compareTo(ExternalDocumentRef o) {
        Optional<Checksum> comparechecksum;
        Optional<Checksum> myChecksum;
        String compareDocumentNamespace;
        String myDocumentNamespace;
        int retval = 0;
        try {
            myDocumentNamespace = this.getSpdxDocumentNamespace();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.warn("Error getting document namepsace", e2);
            myDocumentNamespace = "";
        }
        try {
            compareDocumentNamespace = o.getSpdxDocumentNamespace();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.warn("Error getting compare document namepsace", e3);
            compareDocumentNamespace = "";
        }
        retval = myDocumentNamespace.compareTo(compareDocumentNamespace);
        if (retval != 0) {
            return retval;
        }
        try {
            myChecksum = this.getChecksum();
        }
        catch (InvalidSPDXAnalysisException e4) {
            logger.warn("Error getting checksum", e4);
            myChecksum = Optional.empty();
        }
        try {
            comparechecksum = o.getChecksum();
        }
        catch (InvalidSPDXAnalysisException e5) {
            logger.warn("Error getting compare checksum", e5);
            comparechecksum = Optional.empty();
        }
        if (!comparechecksum.isPresent()) {
            if (myChecksum.isPresent()) {
                return 1;
            }
        } else {
            if (!myChecksum.isPresent()) {
                return -1;
            }
            retval = myChecksum.get().compareTo(comparechecksum.get());
        }
        return retval;
    }
}

