/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxObjectNotInStoreException;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelStorageClassConverter;
import org.spdx.library.model.SpdxIdNotFoundException;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.storage.IModelStore;

public class ModelCollection<T>
implements Collection<Object> {
    private IModelStore modelStore;
    private String documentUri;
    private String id;
    private String propertyName;
    private ModelCopyManager copyManager;
    private Class<?> type;
    private boolean licensePrimitiveAssignable;
    private Function<Object, Object> checkConvertTypedValue = value -> this.checkConvertTypedValue(value);

    public ModelCollection(IModelStore modelStore, String documentUri, String id, String propertyName, @Nullable ModelCopyManager copyManager, @Nullable Class<?> type) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        this.modelStore = modelStore;
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        this.documentUri = documentUri;
        Objects.requireNonNull(id, "ID can not be null");
        this.id = id;
        Objects.requireNonNull(propertyName, "Property name can not be null");
        this.propertyName = propertyName;
        this.copyManager = copyManager;
        if (!modelStore.exists(documentUri, id)) {
            throw new SpdxIdNotFoundException(String.valueOf(id) + " does not exist in document " + documentUri);
        }
        if (Objects.nonNull(type)) {
            this.type = type;
            this.licensePrimitiveAssignable = type.isAssignableFrom(SpdxNoneLicense.class);
            if (!modelStore.isCollectionMembersAssignableTo(documentUri, id, propertyName, type)) {
                throw new SpdxInvalidTypeException("Incompatible type for property " + propertyName + ": " + type.toString());
            }
        } else {
            this.licensePrimitiveAssignable = false;
        }
    }

    @Override
    public int size() {
        try {
            return this.modelStore.collectionSize(this.documentUri, this.id, this.propertyName);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.modelStore.collectionSize(this.documentUri, this.id, this.propertyName) == 0;
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean contains(Object o) {
        Object storedObject;
        try {
            storedObject = null;
            try {
                storedObject = ModelStorageClassConverter.modelObjectToStoredObject(o, this.documentUri, this.modelStore, this.copyManager);
            }
            catch (SpdxObjectNotInStoreException e1) {
                return false;
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
        return this.modelStore.collectionContains(this.documentUri, this.id, this.propertyName, storedObject);
    }

    private Object checkConvertTypedValue(Object value) {
        try {
            Object retval = ModelStorageClassConverter.storedObjectToModelObject(value, this.documentUri, this.modelStore, this.copyManager);
            if (this.licensePrimitiveAssignable && retval instanceof IndividualUriValue) {
                String uri = ((IndividualUriValue)retval).getIndividualURI();
                if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                    retval = new SpdxNoAssertionLicense();
                } else if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                    retval = new SpdxNoneLicense();
                }
            }
            if (Objects.nonNull(this.type) && !this.type.isAssignableFrom(retval.getClass())) {
                if (retval instanceof IndividualUriValue) {
                    throw new SpdxInvalidTypeException("No enumeration was found for URI " + ((IndividualUriValue)retval).getIndividualURI() + " for type " + this.type.toString());
                }
                throw new SpdxInvalidTypeException("A collection element of type " + retval.getClass().toString() + " was found in a collection of type " + this.type.toString());
            }
            return retval;
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    public List<Object> toImmutableList() {
        return Collections.unmodifiableList(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).map(this.checkConvertTypedValue).collect(Collectors.toList()));
    }

    @Override
    public Iterator<Object> iterator() {
        try {
            return new ModelCollectionIterator(this.modelStore.listValues(this.documentUri, this.id, this.propertyName));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toImmutableList().toArray();
    }

    @Override
    public <AT> AT[] toArray(AT[] a) {
        return this.toImmutableList().toArray(a);
    }

    @Override
    public boolean add(Object element) {
        try {
            return this.modelStore.addValueToCollection(this.documentUri, this.id, this.propertyName, ModelStorageClassConverter.modelObjectToStoredObject(element, this.documentUri, this.modelStore, this.copyManager));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean remove(Object element) {
        try {
            return this.modelStore.removeValueFromCollection(this.documentUri, this.id, this.propertyName, ModelStorageClassConverter.modelObjectToStoredObject(element, this.documentUri, this.modelStore, null));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.toImmutableList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        boolean retval = false;
        Iterator<? extends Object> iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.add(iter.next())) continue;
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = false;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<Object> values = this.toImmutableList();
        boolean retval = false;
        for (Object value : values) {
            if (c.contains(value) || !this.remove(value)) continue;
            retval = true;
        }
        return retval;
    }

    @Override
    public void clear() {
        try {
            this.modelStore.clearValueCollection(this.documentUri, this.id, this.propertyName);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
    }

    public IModelStore getModelStore() {
        return this.modelStore;
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public String getId() {
        return this.id;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    class ModelCollectionIterator
    implements Iterator<Object> {
        private Iterator<Object> storageIterator;

        public ModelCollectionIterator(Iterator<Object> storageIterator) {
            this.storageIterator = storageIterator;
        }

        @Override
        public boolean hasNext() {
            return this.storageIterator.hasNext();
        }

        @Override
        public Object next() {
            return ModelCollection.this.checkConvertTypedValue(this.storageIterator.next());
        }
    }
}

