/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelCollection;
import org.spdx.storage.IModelStore;

public class ModelSet<T>
extends ModelCollection<T> {
    static final Logger logger = LoggerFactory.getLogger(ModelSet.class);

    public ModelSet(IModelStore modelStore, String documentUri, String id, String propertyName, @Nullable ModelCopyManager copyManager, @Nullable Class<?> type) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, propertyName, copyManager, type);
    }

    @Override
    public boolean add(Object element) {
        IModelStore.IModelStoreLock lock;
        try {
            lock = this.getModelStore().enterCriticalSection(this.getDocumentUri(), false);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
        try {
            if (!super.contains(element)) {
                boolean bl = super.add(element);
                return bl;
            }
            return false;
        }
        finally {
            this.getModelStore().leaveCriticalSection(lock);
        }
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        IModelStore.IModelStoreLock lock;
        try {
            lock = this.getModelStore().enterCriticalSection(this.getDocumentUri(), false);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new RuntimeException(e2);
        }
        try {
            boolean retval = false;
            for (Object object : c) {
                if (super.contains(object) || !super.add(object)) continue;
                retval = true;
            }
            boolean bl = retval;
            return bl;
        }
        finally {
            this.getModelStore().leaveCriticalSection(lock);
        }
    }
}

