/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.Version;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.storage.IModelStore;

public abstract class SpdxItem
extends SpdxElement {
    public SpdxItem() throws InvalidSPDXAnalysisException {
    }

    public SpdxItem(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxItem(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    protected String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoFromFiles";
    }

    public AnyLicenseInfo getLicenseConcluded() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue("licenseConcluded");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No license concluded stored, returning NOASSERTION");
        return new SpdxNoAssertionLicense(this.getModelStore(), this.getDocumentUri());
    }

    public SpdxItem setLicenseConcluded(@Nullable AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseConcluded", license);
        return this;
    }

    public Collection<AnyLicenseInfo> getLicenseInfoFromFiles() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValueSet(this.getLicenseInfoFromFilesPropertyName(), AnyLicenseInfo.class);
    }

    public String getCopyrightText() throws InvalidSPDXAnalysisException {
        Optional<String> retval = this.getStringPropertyValue("copyrightText");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("Missing required copyright text.  Returning empty string");
        return "";
    }

    public SpdxItem setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("copyrightText", copyrightText);
        return this;
    }

    public Collection<String> getAttributionText() throws InvalidSPDXAnalysisException {
        return this.getStringCollection("attributionText");
    }

    @Override
    public SpdxItem setName(String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getLicenseComments() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("licenseComments");
    }

    public SpdxItem setLicenseComments(String licenseComments) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseComments", licenseComments);
        return this;
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        String name = "UNKNOWN";
        try {
            Optional<String> myName = this.getName();
            if (myName.isPresent()) {
                name = myName.get();
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting name: " + e2.getMessage());
        }
        try {
            Optional<AnyLicenseInfo> concluded = this.getAnyLicenseInfoPropertyValue("licenseConcluded");
            if (!concluded.isPresent()) {
                if (Version.versionLessThan(specVersion, "SPDX-2.3")) {
                    retval.add("Missing required concluded license for " + name);
                }
            } else {
                retval.addAll(concluded.get().verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting license concluded: " + e3.getMessage());
        }
        try {
            String copyrightText = this.getCopyrightText();
            if (copyrightText.isEmpty() && Version.versionLessThan(specVersion, "SPDX-2.3")) {
                retval.add("Missing required copyright text for " + name);
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting comment: " + e4.getMessage());
        }
        try {
            this.verifyCollection(this.getLicenseInfoFromFiles(), "SPDX Item " + name + " ", verifiedIds, specVersion);
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting license information from files: " + e5.getMessage());
        }
        this.addNameToWarnings(retval);
        return retval;
    }
}

