/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.pointer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.storage.IModelStore;

public abstract class SinglePointer
extends ModelObject
implements Comparable<SinglePointer> {
    static final Logger logger = LoggerFactory.getLogger(SinglePointer.class);

    public SinglePointer() throws InvalidSPDXAnalysisException {
    }

    public SinglePointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SinglePointer(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Nullable
    public SpdxElement getReference() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("reference");
        if (!retval.isPresent()) {
            return null;
        }
        if (!(retval.get() instanceof SpdxElement)) {
            throw new SpdxInvalidTypeException("Invalid type for reference.  Expect SdpxElement, found " + retval.get().getClass().toString());
        }
        return (SpdxElement)retval.get();
    }

    public void setReference(SpdxElement reference) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(reference)) {
            throw new InvalidSPDXAnalysisException("Can not set required reference to null");
        }
        this.setPropertyValue("reference", reference);
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            SpdxElement reference = this.getReference();
            if (Objects.isNull(reference)) {
                retval.add("Missing required reference field");
            } else {
                retval.addAll(reference.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting reference: " + e2.getMessage());
        }
        return retval;
    }

    protected int compareReferences(SinglePointer o) {
        SpdxElement reference;
        SpdxElement compRef;
        block13: {
            block12: {
                if (o == null) {
                    return 1;
                }
                compRef = null;
                try {
                    compRef = o.getReference();
                    reference = this.getReference();
                    if (reference != null) break block12;
                    if (compRef == null) {
                        return 0;
                    }
                    return -1;
                }
                catch (InvalidSPDXAnalysisException e2) {
                    logger.error("Error getting comparison reference element", e2);
                    return -1;
                }
            }
            if (compRef != null) break block13;
            return 1;
        }
        String myName = "";
        try {
            Optional<String> name = reference.getName();
            if (name.isPresent()) {
                myName = name.get();
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            logger.warn("Error getting reference name", ex);
        }
        String compName = "";
        try {
            Optional<String> cName = compRef.getName();
            if (cName.isPresent()) {
                compName = cName.get();
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            logger.warn("Error getting compare name", ex);
        }
        return myName.compareTo(compName);
    }
}

