/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.SpdxConstants;
import org.spdx.spdxRdfStore.SpdxOwlOntology;

public class SpdxResourceFactory {
    static final Logger logger = LoggerFactory.getLogger(SpdxResourceFactory.class.getName());
    public static final Set<String> RDF_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.RDF_PROPERTIES)));
    public static final Set<String> RDFS_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.RDFS_PROPERTIES)));
    public static final Set<String> DOAP_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.DOAP_CLASSES)));
    public static final Set<String> DOAP_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.DOAP_PROPERTIES)));
    public static final Set<String> OWL_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.OWL_PROPERTIES)));
    public static final Set<String> POINTER_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.POINTER_CLASSES)));
    public static final Set<String> POINTER_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.POINTER_PROPERTIES)));

    public static Resource typeToResource(String type) {
        Objects.requireNonNull(type);
        if (DOAP_TYPES.contains(type)) {
            return ResourceFactory.createResource("http://usefulinc.com/ns/doap#" + type);
        }
        if (POINTER_TYPES.contains(type)) {
            return ResourceFactory.createResource("http://www.w3.org/2009/pointers#" + type);
        }
        return ResourceFactory.createResource("http://spdx.org/rdf/terms#" + type);
    }

    public static String classNameToUri(String className) {
        Objects.requireNonNull(className);
        if (DOAP_TYPES.contains(className)) {
            return "http://usefulinc.com/ns/doap#" + className;
        }
        if (POINTER_TYPES.contains(className)) {
            return "http://www.w3.org/2009/pointers#" + className;
        }
        return "http://spdx.org/rdf/terms#" + className;
    }

    public static String propertyNameToUri(String propertyName) {
        Objects.requireNonNull(propertyName);
        if (RDF_PROPERTIES.contains(propertyName)) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#" + propertyName;
        }
        if (RDFS_PROPERTIES.contains(propertyName)) {
            return "http://www.w3.org/2000/01/rdf-schema#" + propertyName;
        }
        if (DOAP_PROPERTIES.contains(propertyName)) {
            return "http://usefulinc.com/ns/doap#" + propertyName;
        }
        if (OWL_PROPERTIES.contains(propertyName)) {
            return "http://www.w3.org/2002/07/owl#" + propertyName;
        }
        if (POINTER_PROPERTIES.contains(propertyName)) {
            return "http://www.w3.org/2009/pointers#" + propertyName;
        }
        return SpdxOwlOntology.checkGetOwlUriFromRenamed("http://spdx.org/rdf/terms#" + propertyName);
    }

    public static Optional<String> resourceToSpdxType(Resource type) {
        if (!type.isURIResource()) {
            return Optional.empty();
        }
        String typeUri = type.getURI();
        if (typeUri == null) {
            return Optional.empty();
        }
        if (typeUri.startsWith("http://usefulinc.com/ns/doap#")) {
            return Optional.of(typeUri.substring("http://usefulinc.com/ns/doap#".length()));
        }
        if (typeUri.startsWith("http://www.w3.org/2009/pointers#")) {
            return Optional.of(typeUri.substring("http://www.w3.org/2009/pointers#".length()));
        }
        if (typeUri.startsWith("http://spdx.org/rdf/terms#")) {
            return Optional.of(typeUri.substring("http://spdx.org/rdf/terms#".length()));
        }
        logger.warn("Unknown resource type: " + typeUri);
        return Optional.empty();
    }
}

