/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.DocumentInfoSheet;
import org.spdx.spreadsheetstore.SpdxSpreadsheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class DocumentInfoSheetV2d0
extends DocumentInfoSheet {
    static final int NUM_COLS = 14;
    static final int SPDX_VERSION_COL = 1;
    static final int DATA_LICENSE_COL = 2;
    static final int SPDX_ID_COL = 3;
    static final int LICENSE_LIST_VERSION_COL = 4;
    static final int DOCUMENT_NAME_COL = 5;
    static final int NAMESPACE_COL = 6;
    static final int DOCUMENT_DESCRIBES_COL = 7;
    static final int EXTERNAL_DOC_REFS_COL = 8;
    static final int DOCUMENT_COMMENT_COL = 9;
    static final int CREATED_BY_COL = 10;
    static final int CREATED_COL = 11;
    static final int AUTHOR_COMMENTS_COL = 12;
    static final int USER_DEFINED_COL = 13;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    private static Pattern EXTERNAL_DOC_REF_PATTERN;

    static {
        boolean[] blArray = new boolean[14];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[10] = true;
        blArray[11] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"Spreadsheet Version", "SPDX Version", "Data License", "SPDX Identifier", "License List Version", "Document Name", "Document Namespace", "Document Contents", "External Document References", "Document Comment", "Creator", "Created", "Creator Comment", "Optional User Defined Columns..."};
        COLUMN_WIDTHS = new int[]{20, 16, 20, 20, 16, 40, 80, 50, 140, 70, 60, 20, 70, 60};
        boolean[] blArray2 = new boolean[14];
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[14];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        blArray3[11] = true;
        CENTER_NOWRAP = blArray3;
        EXTERNAL_DOC_REF_PATTERN = DocumentInfoSheetV2d0.getExternalDocPattern();
    }

    public DocumentInfoSheetV2d0(Workbook workbook, String sheetName, String version2, IModelStore modelStore, ModelCopyManager copyManager) throws SpreadsheetException {
        super(workbook, sheetName, version2, modelStore, copyManager);
    }

    @Override
    public String verify() {
        block13: {
            block12: {
                block11: {
                    if (this.sheet != null) break block11;
                    return "Worksheet for SPDX Origins does not exist";
                }
                this.version = this.getDataCellStringValue(0);
                if (this.version != null) break block12;
                return "Invalid origins spreadsheet - no spreadsheet version found";
            }
            if (!SpdxSpreadsheet.verifyVersion(this.version)) {
                return "Spreadsheet version " + this.version + " not supported.";
            }
            String namespace2 = this.getNamespace();
            if (!Objects.isNull(namespace2) && !namespace2.isEmpty()) break block13;
            return "Missing document namespace";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 13) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX Origins worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(1) == null || row.getCell(1).getCellType() == CellType.BLANK || row.getCell(1).getCellType() == CellType.STRING && row.getCell(1).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Origins work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 14) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (REQUIRED[i]) {
                    return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(String.valueOf(row.getRowNum()) + " in Origins Spreadsheet");
                }
            } else if (i == 11 && cell.getCellTypeEnum() != CellType.NUMERIC) {
                return "Created column in origin spreadsheet is not of type Date";
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName, String documentUri) {
        Objects.requireNonNull(wb, "Missing required workbook");
        Objects.requireNonNull(sheetName, "Missing required sheet name");
        Objects.requireNonNull(documentUri, "Missing required document Uri");
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
        Row dataRow = sheet.createRow(1);
        Cell ssVersionCell = dataRow.createCell(0);
        ssVersionCell.setCellValue("2.3.0");
        Cell ssNamespaceCell = dataRow.createCell(6);
        ssNamespaceCell.setCellValue(documentUri);
    }

    @Override
    public void setAuthorComments(String comments) {
        this.setDataCellStringValue(12, comments);
    }

    public void setCreatedBy(String createdBy) {
        this.setDataCellStringValue(10, createdBy);
    }

    @Override
    public void setDataLicense(String dataLicense) {
        this.setDataCellStringValue(2, dataLicense);
    }

    @Override
    public void setSPDXVersion(String version2) {
        this.setDataCellStringValue(1, version2);
    }

    public void setSpreadsheetVersion(String version2) {
        this.setDataCellStringValue(0, version2);
    }

    @Override
    public String getAuthorComments() {
        return this.getDataCellStringValue(12);
    }

    @Override
    public Date getCreated() {
        return this.getDataCellDateValue(11);
    }

    @Override
    public String getDataLicense() {
        return this.getDataCellStringValue(2);
    }

    @Override
    public String getSPDXVersion() {
        return this.getDataCellStringValue(1);
    }

    public String getSpreadsheetVersion() {
        return this.getDataCellStringValue(0);
    }

    @Override
    public void setCreatedBy(Collection<String> createdByCollection) {
        Cell cell;
        Row row;
        if (Objects.isNull(createdByCollection) || createdByCollection.isEmpty()) {
            this.setDataCellStringValue(10, "");
            int i = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i);
            while (nextRow != null) {
                Cell createdByCell = nextRow.getCell(10);
                if (createdByCell != null) {
                    createdByCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i);
            }
            return;
        }
        String[] createdBy = createdByCollection.toArray(new String[createdByCollection.size()]);
        this.setDataCellStringValue(10, createdBy[0]);
        int i = 1;
        while (i < createdBy.length) {
            row = this.getDataRow(i);
            cell = row.getCell(10);
            if (cell == null) {
                cell = row.createCell(10);
            }
            cell.setCellValue(createdBy[i]);
            ++i;
        }
        i = this.firstRowNum + 1 + createdBy.length;
        while (i <= this.lastRowNum) {
            row = this.sheet.getRow(i);
            cell = row.getCell(10);
            if (cell != null) {
                row.removeCell(cell);
            }
            ++i;
        }
    }

    @Override
    public List<String> getCreatedBy() {
        ArrayList<String> retval = new ArrayList<String>();
        int i = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + i) != null && this.sheet.getRow(this.firstRowNum + 1 + i).getCell(10) != null && !this.sheet.getRow(this.firstRowNum + 1 + i).getCell(10).getStringCellValue().isEmpty()) {
            retval.add(this.sheet.getRow(this.firstRowNum + 1 + i).getCell(10).getStringCellValue());
            ++i;
        }
        return retval;
    }

    @Override
    public void setCreated(Date created) {
        this.setDataCellDateValue(11, created);
    }

    @Override
    public String getDocumentComment() {
        return this.getDataCellStringValue(9);
    }

    @Override
    public void setDocumentComment(String docComment) {
        this.setDataCellStringValue(9, docComment);
    }

    @Override
    public String getLicenseListVersion() {
        return this.getDataCellStringValue(4);
    }

    @Override
    public void setLicenseListVersion(String licenseVersion) {
        this.setDataCellStringValue(4, licenseVersion);
    }

    @Override
    public String getNamespace() {
        return this.getDataCellStringValue(6);
    }

    @Override
    public void addDocument(SpdxDocument doc) throws SpreadsheetException {
        Optional<String> licenseListVersion;
        Optional<String> docComment;
        String created;
        Optional<String> comments;
        AnyLicenseInfo dataLicense;
        Collection<String> createdBys;
        SpdxCreatorInformation creator;
        try {
            this.setSPDXVersion(doc.getSpecVersion());
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting the spec version info: " + e2.getMessage());
        }
        try {
            creator = doc.getCreationInfo();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the creation info: " + e1.getMessage());
        }
        try {
            createdBys = creator.getCreators();
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting the creators: " + e2.getMessage());
        }
        this.setCreatedBy(createdBys);
        try {
            dataLicense = doc.getDataLicense();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the data license info: " + e1.getMessage());
        }
        if (dataLicense != null && dataLicense instanceof SimpleLicensingInfo) {
            this.setDataLicense(((SimpleLicensingInfo)dataLicense).getLicenseId());
        }
        try {
            comments = creator.getComment();
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting the creator comment: " + e2.getMessage());
        }
        if (comments.isPresent()) {
            this.setAuthorComments(comments.get());
        }
        try {
            created = creator.getCreated();
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting created: " + e2.getMessage());
        }
        if (created == null) {
            throw new SpreadsheetException("Missing created date");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            this.setCreated(dateFormat.parse(created));
        }
        catch (ParseException e2) {
            throw new SpreadsheetException("Invalid created date - unable to parse");
        }
        try {
            docComment = doc.getComment();
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting the document comment: " + e2.getMessage());
        }
        if (docComment.isPresent()) {
            this.setDocumentComment(docComment.get());
        }
        try {
            licenseListVersion = doc.getCreationInfo().getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error getting the license list info: " + e3.getMessage());
        }
        if (licenseListVersion.isPresent()) {
            this.setLicenseListVersion(licenseListVersion.get());
        }
        this.setSpdxId(doc.getId());
        try {
            Optional<String> name = doc.getName();
            if (name.isPresent()) {
                this.setDocumentName(name.get());
            } else {
                this.setDocumentName("");
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting the document name: " + e2.getMessage());
        }
        this.setNamespace(doc.getDocumentUri());
        Collection<SpdxElement> contents = null;
        try {
            contents = doc.getDocumentDescribes();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the document describes: " + e1.getMessage());
        }
        ArrayList<String> contentIds = new ArrayList<String>();
        for (SpdxElement element : contents) {
            contentIds.add(element.getId());
        }
        Collections.sort(contentIds);
        this.setDocumentDescribes(contentIds);
        try {
            this.setExternalDocumentRefs(doc.getExternalDocumentRefs());
        }
        catch (InvalidSPDXAnalysisException e4) {
            throw new SpreadsheetException("Error getting the external document references: " + e4.getMessage());
        }
    }

    private void setNamespace(String namespace2) {
        this.setDataCellStringValue(6, namespace2);
    }

    @Override
    public String getSpdxId() {
        return this.getDataCellStringValue(3);
    }

    @Override
    public void setSpdxId(String id) {
        this.setDataCellStringValue(3, id);
    }

    @Override
    public String getDocumentName() {
        return this.getDataCellStringValue(5);
    }

    @Override
    public void setDocumentName(String documentName) {
        this.setDataCellStringValue(5, documentName);
    }

    @Override
    public Collection<String> getDocumentContents() {
        ArrayList<String> retval = new ArrayList<String>();
        int i = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + i) != null && this.sheet.getRow(this.firstRowNum + 1 + i).getCell(7) != null && !this.sheet.getRow(this.firstRowNum + 1 + i).getCell(7).getStringCellValue().isEmpty()) {
            retval.add(this.sheet.getRow(this.firstRowNum + 1 + i).getCell(7).getStringCellValue());
            ++i;
        }
        return retval;
    }

    @Override
    public void setDocumentDescribes(Collection<String> contentsCollection) {
        Cell cell;
        Row row;
        String[] contents = contentsCollection.toArray(new String[contentsCollection.size()]);
        if (contents == null || contents.length < 1) {
            this.setDataCellStringValue(7, "");
            int i = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i);
            while (nextRow != null) {
                Cell documentDescribesCell = nextRow.getCell(7);
                if (documentDescribesCell != null) {
                    documentDescribesCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i);
            }
            return;
        }
        this.setDataCellStringValue(7, contents[0]);
        int i = 1;
        while (i < contents.length) {
            row = this.getDataRow(i);
            cell = row.getCell(7);
            if (cell == null) {
                cell = row.createCell(7);
            }
            cell.setCellValue(contents[i]);
            ++i;
        }
        i = this.firstRowNum + 1 + contents.length;
        while (i <= this.lastRowNum) {
            row = this.sheet.getRow(i);
            cell = row.getCell(7);
            if (cell != null) {
                row.removeCell(cell);
            }
            ++i;
        }
    }

    @Override
    public Collection<ExternalDocumentRef> getExternalDocumentRefs() throws SpreadsheetException {
        ArrayList<ExternalDocumentRef> retval = new ArrayList<ExternalDocumentRef>();
        int i = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + i) != null && this.sheet.getRow(this.firstRowNum + 1 + i).getCell(8) != null && !this.sheet.getRow(this.firstRowNum + 1 + i).getCell(8).getStringCellValue().isEmpty()) {
            retval.add(this.parseExternalDocumentRef(this.sheet.getRow(this.firstRowNum + 1 + i).getCell(8).getStringCellValue(), this.firstRowNum + 1 + i));
            ++i;
        }
        return retval;
    }

    @Override
    public void setExternalDocumentRefs(Collection<ExternalDocumentRef> externalDocumentRefColleciton) throws SpreadsheetException {
        Cell cell;
        Row row;
        if (Objects.isNull(externalDocumentRefColleciton) || externalDocumentRefColleciton.size() < 1) {
            this.setDataCellStringValue(8, "");
            int i = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i);
            while (nextRow != null) {
                Cell externalDocRefsCell = nextRow.getCell(8);
                if (externalDocRefsCell != null) {
                    externalDocRefsCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i);
            }
            return;
        }
        ExternalDocumentRef[] externalDocumentRefs = externalDocumentRefColleciton.toArray(new ExternalDocumentRef[externalDocumentRefColleciton.size()]);
        try {
            this.setDataCellStringValue(8, this.externalDocRefToStr(externalDocumentRefs[0]));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting external document reference", e2);
        }
        int i = 1;
        while (i < externalDocumentRefs.length) {
            row = this.getDataRow(i);
            cell = row.getCell(8);
            if (cell == null) {
                cell = row.createCell(8);
            }
            try {
                cell.setCellValue(this.externalDocRefToStr(externalDocumentRefs[i]));
            }
            catch (InvalidSPDXAnalysisException e3) {
                throw new SpreadsheetException("Error getting external document reference", e3);
            }
            ++i;
        }
        i = this.firstRowNum + 1 + externalDocumentRefs.length;
        while (i <= this.lastRowNum) {
            row = this.sheet.getRow(i);
            cell = row.getCell(8);
            if (cell != null) {
                row.removeCell(cell);
            }
            ++i;
        }
    }

    static Pattern getExternalDocPattern() {
        StringBuilder sb = new StringBuilder("(\\S+)\\s+(\\S+)\\s+(");
        ChecksumAlgorithm[] values = ChecksumAlgorithm.values();
        sb.append(values[0].toString());
        int i = 1;
        while (i < values.length) {
            sb.append('|');
            sb.append(values[i].toString());
            ++i;
        }
        sb.append("):\\s+(\\S+)");
        return Pattern.compile(sb.toString());
    }

    private ExternalDocumentRef parseExternalDocumentRef(String refStr, int rowNumber) throws SpreadsheetException {
        Checksum checksum;
        ChecksumAlgorithm algorithm;
        Matcher matcher = EXTERNAL_DOC_REF_PATTERN.matcher(refStr.trim());
        if (!matcher.find()) {
            throw new SpreadsheetException("Invalid external document reference: " + refStr + " at row number " + rowNumber);
        }
        try {
            algorithm = ChecksumAlgorithm.valueOf(matcher.group(3));
        }
        catch (IllegalArgumentException ex) {
            throw new SpreadsheetException("Invalid checksum algorithm: " + refStr + " at row number " + rowNumber);
        }
        try {
            checksum = Checksum.create(this.modelStore, this.documentUri, algorithm, matcher.group(4));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error creating checksum for external document reference: " + refStr + " at row number " + rowNumber);
        }
        try {
            return checksum.createExternalDocumentRef(matcher.group(1), matcher.group(2), checksum);
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error creating ExternalDocumentRef for external document reference: " + refStr + " at row number " + rowNumber);
        }
    }

    private String externalDocRefToStr(ExternalDocumentRef externalDocumentRef) throws InvalidSPDXAnalysisException {
        String value;
        String algorithm;
        if (externalDocumentRef == null) {
            return "";
        }
        Optional<Checksum> checksum = externalDocumentRef.getChecksum();
        if (checksum.isPresent()) {
            algorithm = checksum.get().getAlgorithm().toString();
            value = checksum.get().getValue();
        } else {
            algorithm = "[UNKNOWN]";
            value = "[UNDEFINED]";
        }
        return String.valueOf(externalDocumentRef.getId()) + " " + externalDocumentRef.getSpdxDocumentNamespace() + " " + algorithm + ":" + " " + value;
    }
}

