/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.ModelCopyManager;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.ExtractedLicenseInfoSheet;
import org.spdx.storage.IModelStore;

public class ExtractedLicenseInfoSheetV1d1
extends ExtractedLicenseInfoSheet {
    static final int NUM_COLS = 6;
    static final int IDENTIFIER_COL = 0;
    static final int EXTRACTED_TEXT_COL = 1;
    static final int LICENSE_NAME_COL = 2;
    static final int CROSS_REF_URL_COL = 3;
    static final int COMMENT_COL = 4;
    static final int USER_DEFINED_COL = 5;
    static boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    private static final int MAX_CELL_CONTENT_SIZE = 32700;

    static {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"Identifier", "Extracted Text", "License Name", "Cross Reference URLs", "Comment", "User Defined Columns..."};
        COLUMN_WIDTHS = new int[]{15, 120, 50, 80, 80, 50};
        boolean[] blArray2 = new boolean[6];
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[6];
        blArray3[0] = true;
        blArray3[2] = true;
        CENTER_NOWRAP = blArray3;
    }

    public ExtractedLicenseInfoSheetV1d1(Workbook workbook, String packageInfoSheetName, String version2, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, packageInfoSheetName, version2, modelStore, documentUri, copyManager);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    @Override
    public String getIdentifier(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell idCell = row.getCell(0);
        if (idCell == null) {
            return null;
        }
        return idCell.getStringCellValue();
    }

    @Override
    public String getExtractedText(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell extractedTextCell = row.getCell(1);
        if (extractedTextCell == null) {
            return null;
        }
        return extractedTextCell.getStringCellValue();
    }

    @Override
    public void add(String identifier, String extractedTextIn, String licenseName, Collection<String> crossRefUrlCollection, String comment) {
        Row row = this.addRow();
        Cell idCell = row.createCell(0);
        idCell.setCellValue(identifier);
        Cell extractedTextCell = row.createCell(1);
        String extractedText = extractedTextIn;
        if (extractedText == null) {
            extractedText = "";
        }
        if (extractedText.length() > 32700) {
            extractedText = "[WARNING: TRUNCATED]" + extractedText.substring(0, 32680);
        }
        extractedTextCell.setCellValue(extractedText);
        if (licenseName != null && !licenseName.isEmpty()) {
            Cell licenseNameCell = row.createCell(2);
            licenseNameCell.setCellValue(licenseName);
        }
        if (crossRefUrlCollection != null && crossRefUrlCollection.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String[] crossRefUrls = crossRefUrlCollection.toArray(new String[crossRefUrlCollection.size()]);
            sb.append(crossRefUrls[0]);
            int i = 1;
            while (i < crossRefUrls.length) {
                sb.append(", ");
                sb.append(crossRefUrls[i]);
                ++i;
            }
            Cell crossRefCell = row.createCell(3);
            crossRefCell.setCellValue(sb.toString());
        }
        if (comment != null && !comment.isEmpty()) {
            Cell commentCell = row.createCell(4);
            commentCell.setCellValue(comment);
        }
    }

    @Override
    public String getLicenseName(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell licenseNameCell = row.getCell(2);
        if (licenseNameCell == null) {
            return null;
        }
        return licenseNameCell.getStringCellValue();
    }

    @Override
    public Collection<String> getCrossRefUrls(int rowNum) {
        ArrayList<String> retval = new ArrayList<String>();
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell crossRefUrlsCell = row.getCell(3);
        if (crossRefUrlsCell == null) {
            return retval;
        }
        String val = crossRefUrlsCell.getStringCellValue();
        if (val.isEmpty()) {
            return retval;
        }
        String[] stringArray = val.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            retval.add(url.trim());
            ++n2;
        }
        return retval;
    }

    @Override
    public String getComment(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell commentCell = row.getCell(4);
        if (commentCell == null) {
            return null;
        }
        return commentCell.getStringCellValue();
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for non-standard Licenses does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 5) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for non-standard Licenses worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getStringCellValue() == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying non-standard License work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 6) {
            Cell cell = row.getCell(i);
            if (cell == null && REQUIRED[i]) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            ++i;
        }
        return null;
    }
}

