/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class ReviewersSheet
extends AbstractSheet {
    static final int NUM_COLS = 3;
    static final int REVIEWER_COL = 0;
    static final int TIMESTAMP_COL = 1;
    static final int COMMENT_COL = 2;
    static final String[] HEADER_TITLES = new String[]{"Reviewer", "Review Date", "Reviewer Comment"};
    static final int[] COLUMN_WIDTHS = new int[]{60, 20, 120};
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    static final boolean[] REQUIRED;
    SimpleDateFormat spdxFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    static {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        LEFT_WRAP = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        CENTER_NOWRAP = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[0] = true;
        blArray3[1] = true;
        REQUIRED = blArray3;
    }

    public ReviewersSheet(Workbook workbook, String sheetName, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, modelStore, documentUri, copyManager);
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for SPDX Reviewers does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 3) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX Reviewers worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Reviewers worksheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 3) {
            Cell cell = row.getCell(i);
            if (REQUIRED[i] && cell == null) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum()) + " in reviewer sheet";
            }
            if (i == 1 && cell.getCellType() != CellType.NUMERIC) {
                return "Timestamp cell is not a numeric type for row " + String.valueOf(row.getRowNum()) + " in Reviewer sheet";
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public String getReviewer(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell reviewer = row.getCell(0);
        if (reviewer == null) {
            return null;
        }
        return reviewer.getStringCellValue();
    }

    public Date getReviewerTimestamp(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell tsCell = row.getCell(1);
        if (tsCell == null) {
            return null;
        }
        return tsCell.getDateCellValue();
    }

    public String getReviewerComment(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell commentCell = row.getCell(2);
        if (commentCell == null) {
            return null;
        }
        return commentCell.getStringCellValue();
    }

    public void addReviewsToDocAnnotations() throws SpreadsheetException {
        SpdxDocument doc;
        try {
            doc = new SpdxDocument(this.modelStore, this.documentUri, this.copyManager, false);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("SPDX document not found.  Create the SPDX document before adding reviewers.", e2);
        }
        int rowNum = this.getFirstDataRow();
        Row row = this.sheet.getRow(rowNum++);
        while (Objects.nonNull(row) && Objects.nonNull(row.getCell(0)) && !row.getCell(0).getStringCellValue().isEmpty()) {
            String annotator = row.getCell(0).getStringCellValue();
            Cell dateCell = row.getCell(1);
            String date2 = Objects.nonNull(dateCell) ? this.spdxFormat.format(dateCell.getDateCellValue()) : this.spdxFormat.format(new Date());
            Cell commentCell = row.getCell(2);
            String comment = Objects.nonNull(commentCell) ? commentCell.getStringCellValue() : "";
            try {
                doc.addAnnotation(doc.createAnnotation(annotator, AnnotationType.REVIEW, date2, comment));
            }
            catch (InvalidSPDXAnalysisException e3) {
                throw new SpreadsheetException("Error adding annotation", e3);
            }
            row = this.sheet.getRow(rowNum++);
        }
    }
}

