/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.InvalidSpdxPropertyException;
import org.spdx.library.model.license.CrossRef;

class CrossRefJson {
    public String match;
    public String url;
    public Boolean isValid;
    public Boolean isLive;
    public String timestamp;
    public Boolean isWayBackLink;
    public Integer order;
    private transient String id;

    public CrossRefJson() {
    }

    public CrossRefJson(CrossRef crossRef) throws InvalidSPDXAnalysisException {
        Optional<Integer> fromOrder;
        Optional<String> fromTimestamp;
        Optional<Boolean> fromIsWayBackLink;
        Optional<Boolean> fromIsLive;
        Optional<Boolean> fromIsValid;
        Optional<String> fromUrl;
        this.id = crossRef.getId();
        Optional<String> fromMatch = crossRef.getMatch();
        if (fromMatch.isPresent()) {
            this.match = fromMatch.get();
        }
        if ((fromUrl = crossRef.getUrl()).isPresent()) {
            this.url = fromUrl.get();
        }
        if ((fromIsValid = crossRef.getValid()).isPresent()) {
            this.isValid = fromIsValid.get();
        }
        if ((fromIsLive = crossRef.getLive()).isPresent()) {
            this.isLive = fromIsLive.get();
        }
        if ((fromIsWayBackLink = crossRef.getIsWayBackLink()).isPresent()) {
            this.isWayBackLink = fromIsWayBackLink.get();
        }
        if ((fromTimestamp = crossRef.getTimestamp()).isPresent()) {
            this.timestamp = fromTimestamp.get();
        }
        if ((fromOrder = crossRef.getOrder()).isPresent()) {
            this.order = fromOrder.get();
        }
    }

    public List<String> getPropertyValueNames() {
        ArrayList<String> retval = new ArrayList<String>();
        if (Objects.nonNull(this.match)) {
            retval.add("match");
        }
        if (Objects.nonNull(this.url)) {
            retval.add("url");
        }
        if (Objects.nonNull(this.isValid)) {
            retval.add("isValid");
        }
        if (Objects.nonNull(this.isLive)) {
            retval.add("isLive");
        }
        if (Objects.nonNull(this.timestamp)) {
            retval.add("timestamp");
        }
        if (Objects.nonNull(this.isWayBackLink)) {
            retval.add("isWayBackLink");
        }
        if (Objects.nonNull(this.order)) {
            retval.add("order");
        }
        return retval;
    }

    public void setPrimativeValue(String propertyName, Object value) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "match": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.match = (String)value;
                break;
            }
            case "url": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.url = (String)value;
                break;
            }
            case "timestamp": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.timestamp = (String)value;
                break;
            }
            case "isValid": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyName);
                }
                this.isValid = (Boolean)value;
                break;
            }
            case "isLive": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyName);
                }
                this.isLive = (Boolean)value;
                break;
            }
            case "isWayBackLink": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected boolean type for " + propertyName);
                }
                this.isWayBackLink = (Boolean)value;
                break;
            }
            case "order": {
                if (!(value instanceof Integer)) {
                    throw new InvalidSpdxPropertyException("Expected integer type for " + propertyName);
                }
                this.order = (Integer)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyName);
            }
        }
    }

    public void clearPropertyValueList(String propertyName) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + " is not a list type.");
    }

    public boolean addPrimitiveValueToList(String propertyName, Object value) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + " is not a list type.");
    }

    public boolean removePrimitiveValueToList(String propertyName, Object value) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + " is not a list type.");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String crossRefId) {
        this.id = crossRefId;
    }

    public List<?> getValueList(String propertyName) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + " is not a list type.");
    }

    @Nullable
    public Object getValue(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "match": {
                return this.match;
            }
            case "url": {
                return this.url;
            }
            case "isValid": {
                return this.isValid;
            }
            case "isLive": {
                return this.isLive;
            }
            case "timestamp": {
                return this.timestamp;
            }
            case "isWayBackLink": {
                return this.isWayBackLink;
            }
            case "order": {
                return this.order;
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyName);
    }

    public void removeProperty(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "match": {
                this.match = null;
                break;
            }
            case "url": {
                this.url = null;
                break;
            }
            case "isValid": {
                this.isValid = null;
                break;
            }
            case "isLive": {
                this.isLive = null;
                break;
            }
            case "timestamp": {
                this.timestamp = null;
                break;
            }
            case "isWayBackLink": {
                this.isWayBackLink = null;
                break;
            }
            case "order": {
                this.order = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyName);
            }
        }
    }

    public boolean isCollectionMembersAssignableTo(String propertyName, Class<?> clazz) {
        return false;
    }

    public boolean isPropertyValueAssignableTo(String propertyName, Class<?> clazz) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "url": 
            case "timestamp": 
            case "match": {
                return String.class.isAssignableFrom(clazz);
            }
            case "isLive": 
            case "isWayBackLink": 
            case "isValid": {
                return Boolean.class.isAssignableFrom(clazz);
            }
            case "order": {
                return Integer.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for CrossRef:" + propertyName);
    }

    public boolean isCollectionProperty(String propertyName) {
        return false;
    }
}

