/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.library.model.pointer.ByteOffsetPointer;
import org.spdx.library.model.pointer.LineCharPointer;
import org.spdx.library.model.pointer.StartEndPointer;
import org.spdx.library.referencetype.ListedReferenceTypes;

public class CommonCode {
    public static void printDoc(SpdxDocument doc, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        Optional<String> licenseListVersion;
        Optional<String> creatorComment;
        Collection<String> creators;
        String docNamespace;
        AnyLicenseInfo dataLicense;
        if (doc == null) {
            CommonCode.println(out, "Warning: No document to print");
            return;
        }
        String spdxVersion = "";
        if (doc.getSpecVersion() != null && doc.getCreationInfo().getCreated() != null) {
            spdxVersion = doc.getSpecVersion();
            CommonCode.println(out, constants.getProperty("PROP_SPDX_VERSION") + spdxVersion);
        }
        if ((dataLicense = doc.getDataLicense()) != null) {
            if (dataLicense instanceof SimpleLicensingInfo) {
                CommonCode.println(out, constants.getProperty("PROP_SPDX_DATA_LICENSE") + ((SimpleLicensingInfo)dataLicense).getLicenseId());
            } else {
                CommonCode.println(out, constants.getProperty("PROP_SPDX_DATA_LICENSE") + dataLicense.toString());
            }
        }
        if ((docNamespace = doc.getDocumentUri()) != null && !docNamespace.isEmpty()) {
            out.println(constants.getProperty("PROP_DOCUMENT_NAMESPACE") + docNamespace);
        }
        CommonCode.printElementProperties(doc, out, constants, "PROP_DOCUMENT_NAME", "PROP_SPDX_COMMENT");
        CommonCode.println(out, "");
        Collection<ExternalDocumentRef> externalRefs = doc.getExternalDocumentRefs();
        if (externalRefs != null && !externalRefs.isEmpty()) {
            String externalDocRefHedr = constants.getProperty("EXTERNAL_DOC_REFS_HEADER");
            if (externalDocRefHedr != null && !externalDocRefHedr.isEmpty()) {
                CommonCode.println(out, externalDocRefHedr);
            }
            for (ExternalDocumentRef externalRef : externalRefs) {
                CommonCode.printExternalDocumentRef(externalRef, out, constants);
            }
        }
        if (!(creators = doc.getCreationInfo().getCreators()).isEmpty()) {
            CommonCode.println(out, constants.getProperty("CREATION_INFO_HEADER"));
            for (String creator : creators) {
                CommonCode.println(out, constants.getProperty("PROP_CREATION_CREATOR") + creator);
            }
        }
        if (doc.getCreationInfo().getCreated() != null && !doc.getCreationInfo().getCreated().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_CREATION_CREATED") + doc.getCreationInfo().getCreated());
        }
        if ((creatorComment = doc.getCreationInfo().getComment()).isPresent() && !creatorComment.get().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_CREATION_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + creatorComment.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((licenseListVersion = doc.getCreationInfo().getLicenseListVersion()).isPresent() && !licenseListVersion.get().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_LIST_VERSION") + licenseListVersion.get());
        }
        CommonCode.printElementAnnotationsRelationships(doc, out, constants, "PROP_DOCUMENT_NAME", "PROP_SPDX_COMMENT");
        CommonCode.println(out, "");
        ArrayList allPackages = new ArrayList();
        try (Stream<?> allPackagesStream = SpdxModelFactory.getElements(doc.getModelStore(), doc.getDocumentUri(), doc.getCopyManager(), SpdxPackage.class);){
            allPackagesStream.forEach(pkg -> allPackages.add(pkg));
        }
        ArrayList<SpdxFile> allFiles = new ArrayList<SpdxFile>();
        try (Stream<?> allFilesStream = SpdxModelFactory.getElements(doc.getModelStore(), doc.getDocumentUri(), doc.getCopyManager(), SpdxFile.class);){
            allFilesStream.forEach(file -> allFiles.add((SpdxFile)file));
        }
        ArrayList<SpdxElement> alreadyPrinted = new ArrayList<SpdxElement>();
        Collection<SpdxElement> items = doc.getDocumentDescribes();
        for (SpdxElement item : items) {
            if (item instanceof SpdxFile) {
                CommonCode.printFile((SpdxFile)item, out, constants);
                alreadyPrinted.add(item);
                continue;
            }
            if (!(items instanceof SpdxSnippet)) continue;
            CommonCode.printSnippet((SpdxSnippet)((Object)items), out, constants);
            alreadyPrinted.add(item);
        }
        for (SpdxElement item : items) {
            if (!(item instanceof SpdxPackage)) continue;
            CommonCode.printPackage((SpdxPackage)item, out, constants, allFiles, doc.getDocumentUri());
            alreadyPrinted.add(item);
        }
        allPackages.forEach(pkg -> {
            if (!alreadyPrinted.contains(pkg)) {
                try {
                    CommonCode.printPackage(pkg, out, constants, allFiles, doc.getDocumentUri());
                }
                catch (InvalidSPDXAnalysisException e2) {
                    out.println("Error printing package: " + e2.getMessage());
                }
            }
        });
        allFiles.forEach(file -> {
            if (!alreadyPrinted.contains(file)) {
                try {
                    CommonCode.printFile(file, out, constants);
                }
                catch (InvalidSPDXAnalysisException e2) {
                    out.println("Error printing file: " + e2.getMessage());
                }
            }
        });
        try (Stream<?> allSnippets = SpdxModelFactory.getElements(doc.getModelStore(), doc.getDocumentUri(), doc.getCopyManager(), SpdxSnippet.class);){
            allSnippets.sorted().forEach(snippet -> {
                if (!alreadyPrinted.contains(snippet)) {
                    try {
                        CommonCode.printSnippet(snippet, out, constants);
                    }
                    catch (InvalidSPDXAnalysisException e2) {
                        out.println("Error printing package: " + e2.getMessage());
                    }
                }
            });
        }
        CommonCode.println(out, "");
        Collection<ExtractedLicenseInfo> extractedLicenseInfos = doc.getExtractedLicenseInfos();
        if (!extractedLicenseInfos.isEmpty()) {
            CommonCode.println(out, constants.getProperty("LICENSE_INFO_HEADER"));
            for (ExtractedLicenseInfo extractedLicenseInfo : extractedLicenseInfos) {
                CommonCode.printLicense(extractedLicenseInfo, out, constants);
            }
        }
    }

    private static void printSnippet(SpdxSnippet spdxSnippet, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        Optional<String> name;
        Optional<String> comment;
        Optional<String> licenseComment;
        Optional<StartEndPointer> lineRange;
        CommonCode.println(out, constants.getProperty("SNIPPET_HEADER"));
        CommonCode.println(out, constants.getProperty("PROP_SNIPPET_SPDX_ID") + spdxSnippet.getId());
        if (spdxSnippet.getSnippetFromFile() != null) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_FROM_FILE_ID") + spdxSnippet.getSnippetFromFile().getId());
        }
        if (spdxSnippet.getByteRange() != null) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_BYTE_RANGE") + CommonCode.formatPointerRange(spdxSnippet.getByteRange()));
        }
        if ((lineRange = spdxSnippet.getLineRange()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_LINE_RANGE") + CommonCode.formatPointerRange(lineRange.get()));
        }
        if (spdxSnippet.getLicenseConcluded() != null) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE") + spdxSnippet.getLicenseConcluded());
        }
        if (spdxSnippet.getLicenseInfoFromFiles() != null) {
            for (AnyLicenseInfo seenLicense : spdxSnippet.getLicenseInfoFromFiles()) {
                CommonCode.println(out, constants.getProperty("PROP_SNIPPET_SEEN_LICENSE") + seenLicense);
            }
        }
        if ((licenseComment = spdxSnippet.getLicenseComments()).isPresent() && !licenseComment.get().trim().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_LIC_COMMENTS") + licenseComment.get());
        }
        if (spdxSnippet.getCopyrightText() != null && !spdxSnippet.getCopyrightText().trim().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_COPYRIGHT") + spdxSnippet.getCopyrightText());
        }
        if ((comment = spdxSnippet.getComment()).isPresent() && !comment.get().trim().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_COMMENT") + comment.get());
        }
        if ((name = spdxSnippet.getName()).isPresent() && !name.get().trim().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_SNIPPET_NAME") + name.get());
        }
        CommonCode.println(out, "");
    }

    private static String formatPointerRange(StartEndPointer pointer) throws InvalidSPDXAnalysisException {
        String start = "[MISSING]";
        String end = "[MISSING]";
        if (pointer.getStartPointer() != null) {
            if (pointer.getStartPointer() instanceof ByteOffsetPointer) {
                start = String.valueOf(((ByteOffsetPointer)pointer.getStartPointer()).getOffset());
            } else if (pointer.getStartPointer() instanceof LineCharPointer) {
                start = String.valueOf(((LineCharPointer)pointer.getStartPointer()).getLineNumber());
            }
        }
        if (pointer.getEndPointer() != null) {
            if (pointer.getEndPointer() instanceof ByteOffsetPointer) {
                end = String.valueOf(((ByteOffsetPointer)pointer.getEndPointer()).getOffset());
            } else if (pointer.getStartPointer() instanceof LineCharPointer) {
                end = String.valueOf(((LineCharPointer)pointer.getEndPointer()).getLineNumber());
            }
        }
        return start + ":" + end;
    }

    private static void printExternalDocumentRef(ExternalDocumentRef externalDocumentRef, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        String id;
        String uri = externalDocumentRef.getSpdxDocumentNamespace();
        if (uri == null || uri.isEmpty()) {
            uri = "[UNSPECIFIED]";
        }
        String sha1 = "[UNSPECIFIED]";
        Optional<Checksum> checksum = externalDocumentRef.getChecksum();
        if (checksum.isPresent() && checksum.get().getValue() != null && !checksum.get().getValue().isEmpty()) {
            sha1 = checksum.get().getValue();
        }
        if ((id = externalDocumentRef.getId()) == null || id.isEmpty()) {
            id = "[UNSPECIFIED]";
        }
        CommonCode.println(out, constants.getProperty("PROP_EXTERNAL_DOC_URI") + id + " " + uri + " SHA1: " + sha1);
    }

    private static void printElementProperties(SpdxElement element, PrintWriter out, Properties constants, String nameProperty, String commentProperty) throws InvalidSPDXAnalysisException {
        Optional<String> comment;
        Optional<String> name = element.getName();
        if (name.isPresent() && !name.get().isEmpty()) {
            CommonCode.println(out, constants.getProperty(nameProperty) + name.get());
        }
        if (element.getId() != null && !element.getId().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_ELEMENT_ID") + element.getId());
        }
        if ((comment = element.getComment()).isPresent() && !comment.get().isEmpty()) {
            CommonCode.println(out, constants.getProperty(commentProperty) + constants.getProperty("PROP_BEGIN_TEXT") + comment.get() + constants.getProperty("PROP_END_TEXT"));
        }
    }

    private static void printElementAnnotationsRelationships(SpdxElement element, PrintWriter out, Properties constants, String nameProperty, String commentProperty) throws InvalidSPDXAnalysisException {
        Collection<Relationship> relationships;
        Collection<Annotation> annotations = element.getAnnotations();
        if (!annotations.isEmpty()) {
            CommonCode.println(out, constants.getProperty("ANNOTATION_HEADER"));
            for (Annotation annotation : annotations) {
                CommonCode.printAnnotation(annotation, element.getId(), out, constants);
            }
        }
        if (!(relationships = element.getRelationships()).isEmpty()) {
            CommonCode.println(out, constants.getProperty("RELATIONSHIP_HEADER"));
            for (Relationship relationship : relationships) {
                CommonCode.printRelationship(relationship, element.getId(), out, constants);
            }
        }
    }

    private static void printRelationship(Relationship relationship, String elementId, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        String relatedElementId = "[MISSING]";
        Optional<SpdxElement> relatedElement = relationship.getRelatedSpdxElement();
        if (relatedElement.isPresent()) {
            relatedElementId = relatedElement.get().getId();
        }
        out.println(constants.getProperty("PROP_RELATIONSHIP") + elementId + " " + relationship.getRelationshipType().toString() + " " + relatedElementId);
    }

    private static void printAnnotation(Annotation annotation, String id, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        out.println(constants.getProperty("PROP_ANNOTATOR") + annotation.getAnnotator());
        out.println(constants.getProperty("PROP_ANNOTATION_DATE") + annotation.getAnnotationDate());
        out.println(constants.getProperty("PROP_ANNOTATION_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + annotation.getComment() + constants.getProperty("PROP_END_TEXT"));
        out.println(constants.getProperty("PROP_ANNOTATION_TYPE") + annotation.getAnnotationType().toString());
        out.println(constants.getProperty("PROP_ANNOTATION_ID") + id);
    }

    private static void printLicense(ExtractedLicenseInfo license, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        Collection<String> seeAlsos;
        if (license.getLicenseId() != null && !license.getLicenseId().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_ID") + license.getLicenseId());
        }
        if (license.getExtractedText() != null && !license.getExtractedText().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_EXTRACTED_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + license.getExtractedText() + constants.getProperty("PROP_END_TEXT"));
        }
        if (license.getName() != null && !license.getName().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_NAME") + license.getName());
        }
        if (!(seeAlsos = license.getSeeAlso()).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String seeAlso : seeAlsos) {
                if (first) {
                    sb.append(seeAlso);
                    first = false;
                    continue;
                }
                sb.append(", ");
                sb.append(seeAlso);
            }
            CommonCode.println(out, constants.getProperty("PROP_SOURCE_URLS") + sb.toString());
        }
        if (license.getSeeAlso() != null && license.getComment() != null && !license.getComment().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_LICENSE_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + license.getComment() + constants.getProperty("PROP_END_TEXT"));
        }
        CommonCode.println(out, "");
    }

    private static void printPackage(SpdxPackage pkg, PrintWriter out, Properties constants, List<SpdxFile> allFiles, String documentNamespace) throws InvalidSPDXAnalysisException {
        Collection<SpdxFile> files;
        Collection<ExternalRef> externalRefs;
        Optional<String> description;
        Optional<String> summary;
        String copyrightText;
        Optional<String> optional;
        Collection<AnyLicenseInfo> licenses;
        Optional<String> sourceInfo;
        Optional<String> homepage;
        Collection<Checksum> checksums;
        Optional<SpdxPackageVerificationCode> verificationCode;
        Optional<String> validUntilDate;
        Optional<String> builtDate;
        Optional<String> releaseDate;
        Optional<Purpose> purpose;
        Optional<String> downloadLocation;
        Optional<String> originator;
        Optional<String> supplier;
        Optional<String> packageFileName;
        CommonCode.println(out, constants.getProperty("PACKAGE_INFO_HEADER"));
        CommonCode.printElementProperties(pkg, out, constants, "PROP_PACKAGE_DECLARED_NAME", "PROP_PACKAGE_COMMENT");
        Optional<String> version2 = pkg.getVersionInfo();
        if (version2.isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_VERSION_INFO") + version2.get());
        }
        if ((packageFileName = pkg.getPackageFileName()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_FILE_NAME") + packageFileName.get());
        }
        if ((supplier = pkg.getSupplier()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SUPPLIER") + supplier.get());
        }
        if ((originator = pkg.getOriginator()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_ORIGINATOR") + originator.get());
        }
        if ((downloadLocation = pkg.getDownloadLocation()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL") + downloadLocation.get());
        }
        if ((purpose = pkg.getPrimaryPurpose()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PRIMARY_PACKAGE_PURPOSE") + purpose.get().toString());
        }
        if ((releaseDate = pkg.getReleaseDate()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_RELEASE_DATE") + releaseDate.get());
        }
        if ((builtDate = pkg.getBuiltDate()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_BUILT_DATE") + builtDate.get());
        }
        if ((validUntilDate = pkg.getValidUntilDate()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_VALID_UNTIL_DATE") + validUntilDate.get());
        }
        if ((verificationCode = pkg.getPackageVerificationCode()).isPresent() && verificationCode.get().getValue() != null && !verificationCode.get().getValue().isEmpty()) {
            String code = constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE") + verificationCode.get().getValue();
            Collection<String> excludedFiles = verificationCode.get().getExcludedFileNames();
            if (!excludedFiles.isEmpty()) {
                StringBuilder excludedFilesBuilder = new StringBuilder("(");
                for (String string : excludedFiles) {
                    if (excludedFilesBuilder.length() > 1) {
                        excludedFilesBuilder.append(", ");
                    }
                    excludedFilesBuilder.append(string);
                }
                excludedFilesBuilder.append(')');
                code = code + excludedFilesBuilder.toString();
            }
            CommonCode.println(out, code);
        }
        if (!(checksums = pkg.getChecksums()).isEmpty()) {
            for (Checksum checksum : checksums) {
                CommonCode.printChecksum(checksum, out, constants, "PROP_PACKAGE_CHECKSUM");
            }
        }
        if ((homepage = pkg.getHomepage()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL") + homepage.get());
        }
        if ((sourceInfo = pkg.getSourceInfo()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SOURCE_INFO") + constants.getProperty("PROP_BEGIN_TEXT") + sourceInfo.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if (pkg.getLicenseConcluded() != null) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE") + pkg.getLicenseConcluded());
        }
        if (!(licenses = pkg.getLicenseInfoFromFiles()).isEmpty()) {
            CommonCode.println(out, constants.getProperty("LICENSE_FROM_FILES_INFO_HEADER"));
            for (AnyLicenseInfo license : licenses) {
                CommonCode.println(out, constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES") + license.toString());
            }
        }
        if (pkg.getLicenseDeclared() != null) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE") + pkg.getLicenseDeclared());
        }
        if ((optional = pkg.getLicenseComments()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT") + constants.getProperty("PROP_BEGIN_TEXT") + optional.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((copyrightText = pkg.getCopyrightText()) != null && !pkg.getCopyrightText().isEmpty()) {
            boolean encloseInText = !SpdxConstants.NONE_VALUE.equals(copyrightText) && !SpdxConstants.NOASSERTION_VALUE.equals(copyrightText);
            CommonCode.print(out, constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT"));
            if (encloseInText) {
                CommonCode.print(out, constants.getProperty("PROP_BEGIN_TEXT"));
            }
            CommonCode.print(out, copyrightText);
            if (encloseInText) {
                CommonCode.print(out, constants.getProperty("PROP_END_TEXT"));
            }
            CommonCode.println(out, "");
        }
        if ((summary = pkg.getSummary()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_SHORT_DESC") + constants.getProperty("PROP_BEGIN_TEXT") + summary.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((description = pkg.getDescription()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_DESCRIPTION") + constants.getProperty("PROP_BEGIN_TEXT") + description.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if (!pkg.getAttributionText().isEmpty()) {
            pkg.getAttributionText().forEach(s -> CommonCode.println(out, constants.getProperty("PROP_PACKAGE_ATTRIBUTION_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + s + constants.getProperty("PROP_END_TEXT")));
        }
        if (!(externalRefs = pkg.getExternalRefs()).isEmpty()) {
            for (ExternalRef externalRef : externalRefs) {
                CommonCode.printExternalRef(out, constants, externalRef, documentNamespace);
            }
        }
        CommonCode.printElementAnnotationsRelationships(pkg, out, constants, "PROP_PACKAGE_DECLARED_NAME", "PROP_PACKAGE_COMMENT");
        if (!pkg.isFilesAnalyzed()) {
            CommonCode.println(out, constants.getProperty("PROP_PACKAGE_FILES_ANALYZED") + "false");
        }
        if (!(files = pkg.getFiles()).isEmpty()) {
            ArrayList<SpdxFile> sortedFileList = new ArrayList<SpdxFile>(pkg.getFiles());
            Collections.sort(sortedFileList);
            CommonCode.println(out, "");
            CommonCode.println(out, constants.getProperty("FILE_INFO_HEADER"));
            for (SpdxFile file : sortedFileList) {
                CommonCode.printFile(file, out, constants);
                allFiles.remove(file);
                CommonCode.println(out, "");
            }
        } else {
            CommonCode.println(out, "");
        }
    }

    private static void printExternalRef(PrintWriter out, Properties constants, ExternalRef externalRef, String docNamespace) throws InvalidSPDXAnalysisException {
        String category = null;
        category = externalRef.getReferenceCategory() == null ? "OTHER" : externalRef.getReferenceCategory().toString().replace('_', '-');
        String referenceType = null;
        if (externalRef.getReferenceType() == null) {
            referenceType = "[MISSING]";
        } else {
            try {
                try {
                    referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(new URI(externalRef.getReferenceType().getIndividualURI()));
                }
                catch (URISyntaxException e2) {
                    referenceType = "[Invalid URI]";
                }
                catch (InvalidSPDXAnalysisException e3) {
                    referenceType = null;
                }
                if (referenceType == null && (referenceType = externalRef.getReferenceType().getIndividualURI()).startsWith(docNamespace + "#")) {
                    referenceType = referenceType.substring(docNamespace.length() + 1);
                }
            }
            catch (InvalidSPDXAnalysisException e4) {
                referenceType = "[ERROR: " + e4.getMessage() + "]";
            }
        }
        String referenceLocator = externalRef.getReferenceLocator();
        if (referenceLocator == null) {
            referenceLocator = "[MISSING]";
        }
        CommonCode.println(out, constants.getProperty("PROP_EXTERNAL_REFERENCE") + category + " " + referenceType + " " + referenceLocator);
        Optional<String> comment = externalRef.getComment();
        if (comment.isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT") + comment.get());
        }
    }

    private static void printChecksum(Checksum checksum, PrintWriter out, Properties constants, String checksumProperty) throws InvalidSPDXAnalysisException {
        out.println(constants.getProperty(checksumProperty) + checksum.getAlgorithm().toString().replaceAll("_", "-") + ": " + checksum.getValue());
    }

    private static void printFile(SpdxFile file, PrintWriter out, Properties constants) throws InvalidSPDXAnalysisException {
        Collection<String> fileContributors;
        Optional<String> noticeText;
        Optional<String> optional;
        Collection<AnyLicenseInfo> collection;
        Collection<Checksum> checksums;
        CommonCode.printElementProperties(file, out, constants, "PROP_FILE_NAME", "PROP_FILE_COMMENT");
        Collection<FileType> fileTypes = file.getFileTypes();
        if (!fileTypes.isEmpty()) {
            for (FileType fileType : fileTypes) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_TYPE") + fileType.toString());
            }
        }
        if (!(checksums = file.getChecksums()).isEmpty()) {
            for (Checksum checksum : checksums) {
                CommonCode.printChecksum(checksum, out, constants, "PROP_FILE_CHECKSUM");
            }
        }
        if (file.getLicenseConcluded() != null) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_LICENSE") + file.getLicenseConcluded().toString());
        }
        if (!(collection = file.getLicenseInfoFromFiles()).isEmpty()) {
            for (AnyLicenseInfo license : collection) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_SEEN_LICENSE") + license.toString());
            }
        }
        if ((optional = file.getLicenseComments()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_LIC_COMMENTS") + optional.get());
        }
        if (file.getCopyrightText() != null && !file.getCopyrightText().isEmpty()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_COPYRIGHT") + constants.getProperty("PROP_BEGIN_TEXT") + file.getCopyrightText() + constants.getProperty("PROP_END_TEXT"));
        }
        if ((noticeText = file.getNoticeText()).isPresent()) {
            CommonCode.println(out, constants.getProperty("PROP_FILE_NOTICE_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + noticeText.get() + constants.getProperty("PROP_END_TEXT"));
        }
        if (!file.getAttributionText().isEmpty()) {
            file.getAttributionText().forEach(s -> CommonCode.println(out, constants.getProperty("PROP_FILE_ATTRIBUTION_TEXT") + constants.getProperty("PROP_BEGIN_TEXT") + s + constants.getProperty("PROP_END_TEXT")));
        }
        if (!(fileContributors = file.getFileContributors()).isEmpty()) {
            for (String fileContributor : fileContributors) {
                CommonCode.println(out, constants.getProperty("PROP_FILE_CONTRIBUTOR") + fileContributor);
            }
        }
        for (SpdxFile fileDepdency : file.getFileDependency()) {
            Optional<String> depName = fileDepdency.getName();
            String depFileName = depName.isPresent() ? depName.get() : "[MISSING]";
            CommonCode.println(out, constants.getProperty("PROP_FILE_DEPENDENCY") + depFileName);
        }
        CommonCode.printElementAnnotationsRelationships(file, out, constants, "PROP_FILE_NAME", "PROP_FILE_COMMENT");
    }

    private static void println(PrintWriter out, String output) {
        if (out != null) {
            out.println(output);
        } else {
            System.out.println(output);
        }
    }

    private static void print(PrintWriter out, String output) {
        if (out != null) {
            out.print(output);
        } else {
            System.out.print(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getTextFromProperties(String path) throws IOException {
        InputStream is = null;
        Properties prop = new Properties();
        try {
            is = CommonCode.class.getClassLoader().getResourceAsStream(path);
            prop.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return prop;
    }
}

