/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.tag.NoCommentInputStream;
import org.spdx.tag.RecognitionException;
import org.spdx.tag.TagValueBehavior;

public class HandBuiltParser {
    private static final String END_TEXT = "</text>";
    private static final String START_TEXT = "<text>";
    Pattern tagPattern = Pattern.compile("^\\w+:");
    private TagValueBehavior buildDocument;
    private NoCommentInputStream textInput;

    public HandBuiltParser(NoCommentInputStream textInput) {
        this.textInput = textInput;
    }

    public void setBehavior(TagValueBehavior buildDocument) {
        this.buildDocument = buildDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void data() throws Exception {
        try {
            boolean inTextBlock = false;
            String tag = "";
            String value = "";
            String nextLine = this.textInput.readLine();
            while (nextLine != null) {
                if (inTextBlock) {
                    if (nextLine.indexOf(START_TEXT) > 0) {
                        throw new RecognitionException("Found a text block inside another text block at line " + this.textInput.getCurrentLineNo() + ".  Expecting " + END_TEXT);
                    }
                    int endText = nextLine.indexOf(END_TEXT);
                    if (endText >= 0) {
                        value = value + "\n" + nextLine.substring(0, endText).trim();
                        inTextBlock = false;
                        this.buildDocument.buildDocument(tag, value, this.textInput.getCurrentLineNo());
                        tag = "";
                        value = "";
                    } else {
                        value = value + "\n" + nextLine;
                    }
                } else {
                    Matcher tagMatcher = this.tagPattern.matcher(nextLine);
                    if (tagMatcher.find()) {
                        tag = tagMatcher.group();
                        int startText = nextLine.indexOf(START_TEXT);
                        if (startText > 0) {
                            value = nextLine.substring(startText + START_TEXT.length()).trim();
                            if (value.contains(END_TEXT)) {
                                value = value.substring(0, value.indexOf(END_TEXT)).trim();
                                this.buildDocument.buildDocument(tag, value, this.textInput.getCurrentLineNo());
                                tag = "";
                                value = "";
                            } else {
                                inTextBlock = true;
                            }
                        } else {
                            value = nextLine.substring(tag.length()).trim();
                            this.buildDocument.buildDocument(tag, value, this.textInput.getCurrentLineNo());
                            tag = "";
                            value = "";
                        }
                    }
                }
                nextLine = this.textInput.readLine();
            }
            if (inTextBlock) {
                throw new RecognitionException("Unterminated text block at line " + this.textInput.getCurrentLineNo() + " Expecting " + END_TEXT);
            }
            this.buildDocument.exit();
        }
        finally {
            this.textInput.close();
        }
    }
}

