/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tagvaluestore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.ExtendedSpdxStore;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.CommonCode;
import org.spdx.tag.HandBuiltParser;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.NoCommentInputStream;
import org.spdx.tag.RecognitionException;

public class TagValueStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    List<String> warnings = new ArrayList<String>();

    public TagValueStore(IModelStore baseStore) {
        super(baseStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
        SpdxDocument doc = new SpdxDocument(this, documentUri, null, false);
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(stream, StandardCharsets.UTF_8), true);
        try {
            CommonCode.printDoc(doc, writer, constants);
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public String deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        this.warnings.clear();
        Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxTagValueConstants.properties");
        NoCommentInputStream nci = new NoCommentInputStream(stream);
        try {
            HandBuiltParser parser = new HandBuiltParser(nci);
            BuildDocument buildDocument = new BuildDocument(this, constants, this.warnings);
            parser.setBehavior(buildDocument);
            parser.data();
            return buildDocument.getDocumentUri();
        }
        catch (RecognitionException e2) {
            throw new InvalidSpdxTagFileException(e2.getMessage());
        }
        catch (InvalidFileFormatException e3) {
            throw new InvalidFileFormatException(e3.getMessage());
        }
        catch (InvalidSPDXAnalysisException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new InvalidSPDXAnalysisException("Unexpected Error: " + e5.getMessage(), e5);
        }
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

