/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.LineColumn;

public class CompareTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    private static final int MAX_NEXT_NORMAL_TEXT_SEARCH_LENGTH = 15;
    private static final int MIN_TOKENS_NORMAL_TEXT_SEARCH = 3;
    String[] compareTokens = new String[0];
    String compareText = "";
    Map<Integer, LineColumn> tokenToLocation = new HashMap<Integer, LineColumn>();
    ParseInstruction topLevelInstruction = new ParseInstruction(null, null, null);
    DifferenceDescription differences = new DifferenceDescription();
    ParseInstruction currentOptionalInstruction = null;
    boolean parsingComplete = false;

    public CompareTemplateOutputHandler(String compareText) throws IOException {
        this.compareText = LicenseCompareHelper.normalizeText(compareText);
        this.compareTokens = LicenseCompareHelper.tokenizeLicenseText(this.compareText, this.tokenToLocation);
    }

    /*
     * Unable to fully structure code
     */
    private int compareText(String[] textTokens, String[] matchTokens, int startToken, int endToken, ParseInstruction instruction) {
        textTokenCounter = 0;
        nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
        matchTokenCounter = startToken;
        nextMatchToken = LicenseCompareHelper.getTokenAt(matchTokens, matchTokenCounter++);
        while (nextTextToken != null) {
            if (nextMatchToken == null) {
                while (nextTextToken != null && LicenseCompareHelper.canSkip(nextTextToken)) {
                    nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
                }
                if (nextTextToken == null) continue;
                return -matchTokenCounter;
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextTextToken, nextMatchToken)) ** GOTO lbl17
            if ((nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++)) == null) continue;
            nextMatchToken = LicenseCompareHelper.getTokenAt(matchTokens, matchTokenCounter++);
            continue;
lbl-1000:
            // 1 sources

            {
                nextMatchToken = LicenseCompareHelper.getTokenAt(matchTokens, matchTokenCounter++);
lbl17:
                // 2 sources

                ** while (nextMatchToken != null && LicenseCompareHelper.canSkip((String)nextMatchToken))
            }
lbl18:
            // 2 sources

            while (nextTextToken != null && LicenseCompareHelper.canSkip(nextTextToken)) {
                nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++);
            }
            if (LicenseCompareHelper.tokensEquivalent(nextMatchToken, nextTextToken)) {
                if ((nextTextToken = LicenseCompareHelper.getTokenAt(textTokens, textTokenCounter++)) == null) continue;
                nextMatchToken = LicenseCompareHelper.getTokenAt(this.compareTokens, matchTokenCounter++);
                continue;
            }
            if (textTokenCounter == textTokens.length && instruction != null && instruction.isFollowingInstructionOptionalSingleToken() && nextMatchToken != null) {
                compareToken = String.valueOf(nextTextToken) + instruction.getNextOptionalTextTokens()[0];
                if (LicenseCompareHelper.tokensEquivalent(compareToken, nextMatchToken)) {
                    instruction.skipNextInstruction();
                    return matchTokenCounter;
                }
                nextNormal = instruction.getNextNormalTextInstruction();
                nextNormalText = LicenseCompareHelper.getFirstLicenseToken(nextNormal.getText());
                if (nextNormalText != null) {
                    compareToken = String.valueOf(compareToken) + nextNormalText;
                    compareWithoutOptional = String.valueOf(nextTextToken) + nextNormalText;
                    if (LicenseCompareHelper.tokensEquivalent(compareToken, nextMatchToken) || LicenseCompareHelper.tokensEquivalent(compareWithoutOptional, nextMatchToken)) {
                        instruction.skipNextInstruction();
                        nextNormal.setSkipFirstToken(true);
                        return matchTokenCounter;
                    }
                }
            }
            return -matchTokenCounter;
        }
        return matchTokenCounter;
    }

    @Override
    public void text(String text) {
        if (this.currentOptionalInstruction != null) {
            this.currentOptionalInstruction.addSubInstruction(new ParseInstruction(null, text, this.currentOptionalInstruction));
        } else {
            this.topLevelInstruction.addSubInstruction(new ParseInstruction(null, text, null));
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        if (this.currentOptionalInstruction != null) {
            this.currentOptionalInstruction.addSubInstruction(new ParseInstruction(rule, null, this.currentOptionalInstruction));
        } else {
            this.topLevelInstruction.addSubInstruction(new ParseInstruction(rule, null, null));
        }
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        ParseInstruction optionalInstruction = new ParseInstruction(rule, null, this.currentOptionalInstruction);
        if (this.currentOptionalInstruction != null) {
            this.currentOptionalInstruction.addSubInstruction(optionalInstruction);
        } else {
            this.topLevelInstruction.addSubInstruction(optionalInstruction);
        }
        this.currentOptionalInstruction = optionalInstruction;
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        if (this.currentOptionalInstruction != null) {
            this.currentOptionalInstruction = this.currentOptionalInstruction.getParent();
            if (this.currentOptionalInstruction == null || this.currentOptionalInstruction.getRule() == null || this.currentOptionalInstruction.getRule().getType() != LicenseTemplateRule.RuleType.BEGIN_OPTIONAL) {
                this.currentOptionalInstruction = null;
            }
        }
    }

    public boolean matches() throws LicenseParserException {
        if (!this.parsingComplete) {
            throw new LicenseParserException("Matches was called prior to completing the parsing.  The method <code>competeParsing()</code> most be called prior to calling <code>matches()</code>");
        }
        return !this.differences.isDifferenceFound();
    }

    public DifferenceDescription getDifferences() {
        return this.differences;
    }

    @Override
    public void completeParsing() throws LicenseParserException {
        this.topLevelInstruction.match(this.compareTokens, 0, this.compareTokens.length - 1, this.compareText, this.differences, this.tokenToLocation);
        this.parsingComplete = true;
    }

    public int textEquivalent(String text, int startToken) {
        HashMap<Integer, LineColumn> textLocations = new HashMap<Integer, LineColumn>();
        String[] textTokens = LicenseCompareHelper.tokenizeLicenseText(text, textLocations);
        return this.compareText(textTokens, this.compareTokens, startToken, this.compareTokens.length - 1, null);
    }

    public class DifferenceDescription {
        private static final int MAX_DIFF_TEXT_LENGTH = 100;
        private boolean differenceFound;
        private String differenceMessage;
        private List<LineColumn> differences;

        public DifferenceDescription(boolean differenceFound, String differenceMessage, List<LineColumn> differences) {
            this.differenceFound = differenceFound;
            this.differenceMessage = differenceMessage;
            this.differences = differences;
        }

        public DifferenceDescription() {
            this.differenceFound = false;
            this.differenceMessage = "No difference found";
            this.differences = new ArrayList<LineColumn>();
        }

        public boolean isDifferenceFound() {
            return this.differenceFound;
        }

        public void setDifferenceFound(boolean differenceFound) {
            this.differenceFound = differenceFound;
        }

        public String getDifferenceMessage() {
            return this.differenceMessage;
        }

        public void setDifferenceMessage(String differenceMessage) {
            this.differenceMessage = differenceMessage;
        }

        public List<LineColumn> getDifferences() {
            return this.differences;
        }

        public void setDifferences(List<LineColumn> differences) {
            this.differences = differences;
        }

        public void addDifference(LineColumn location, String token, String msg, String text, LicenseTemplateRule rule, DifferenceDescription lastOptionalDifference) {
            if (token == null) {
                token = "";
            }
            if (msg == null) {
                msg = "UNKNOWN (null)";
            }
            this.differenceMessage = msg;
            if (location != null) {
                this.differenceMessage = String.valueOf(this.differenceMessage) + " starting at line #" + String.valueOf(location.getLine()) + " column #" + String.valueOf(location.getColumn()) + " \"" + token + "\"";
                this.differences.add(location);
            } else {
                this.differenceMessage = String.valueOf(this.differenceMessage) + " at end of text";
            }
            if (text != null) {
                this.differenceMessage = String.valueOf(this.differenceMessage) + " when comparing to template text \"";
                this.differenceMessage = text.length() > 100 ? String.valueOf(this.differenceMessage) + text.substring(0, 100) + "...\"" : String.valueOf(this.differenceMessage) + text + "\"";
            }
            if (rule != null) {
                this.differenceMessage = String.valueOf(this.differenceMessage) + " while processing rule " + rule.toString();
            }
            if (lastOptionalDifference != null) {
                this.differenceMessage = String.valueOf(this.differenceMessage) + ".  Last optional text was not found due to the optional difference: \n\t" + lastOptionalDifference.getDifferenceMessage();
            }
            this.differenceFound = true;
        }

        static /* synthetic */ boolean access$0(DifferenceDescription differenceDescription) {
            return differenceDescription.differenceFound;
        }
    }

    class ParseInstruction {
        LicenseTemplateRule rule;
        String text;
        List<ParseInstruction> subInstructions;
        ParseInstruction parent;
        private boolean skip = false;
        private boolean skipFirstTextToken = false;
        private DifferenceDescription lastOptionalDifference = null;

        ParseInstruction(LicenseTemplateRule rule, String text, ParseInstruction parent) {
            this.rule = rule;
            this.text = text;
            this.subInstructions = new ArrayList<ParseInstruction>();
            this.parent = parent;
        }

        public String toString() {
            if (this.rule != null) {
                return this.rule.toString();
            }
            if (this.text != null) {
                String retval = "TEXT: '";
                retval = this.text.length() > 10 ? String.valueOf(retval) + this.text.substring(0, 10) + "...'" : String.valueOf(retval) + this.text + "'";
                return retval;
            }
            return "NONE";
        }

        public LicenseTemplateRule getRule() {
            return this.rule;
        }

        public void setRule(LicenseTemplateRule rule) {
            this.rule = rule;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void addSubInstruction(ParseInstruction instruction) {
            if (instruction.getRule() != null && LicenseTemplateRule.RuleType.VARIABLE.equals((Object)instruction.getRule().getType()) && this.subInstructions.size() > 0 && this.subInstructions.get(this.subInstructions.size() - 1).getRule() != null && LicenseTemplateRule.RuleType.VARIABLE.equals((Object)this.subInstructions.get(this.subInstructions.size() - 1).getRule().getType())) {
                LicenseTemplateRule lastRule = this.subInstructions.get(this.subInstructions.size() - 1).getRule();
                lastRule.setMatch("(" + lastRule.getMatch() + ")\\s*(" + instruction.getRule().getMatch() + ")");
                lastRule.setName("combined-" + lastRule.getName() + "-" + instruction.getRule().getName());
                lastRule.setOriginal(String.valueOf(lastRule.getOriginal()) + " " + lastRule.getOriginal());
            } else {
                instruction.setParent(this);
                this.subInstructions.add(instruction);
            }
        }

        public ParseInstruction getParent() {
            return this.parent;
        }

        public void setParent(ParseInstruction parent) {
            this.parent = parent;
        }

        public List<ParseInstruction> getSubInstructions() {
            return this.subInstructions;
        }

        public boolean onlyText() {
            if (this.subInstructions.size() < 1) {
                return false;
            }
            for (ParseInstruction subInstr : this.subInstructions) {
                if (subInstr.getText() != null) continue;
                return false;
            }
            return true;
        }

        public String toText() {
            StringBuilder sb = new StringBuilder();
            for (ParseInstruction subInstr : this.subInstructions) {
                if (subInstr.getText() == null) continue;
                sb.append(subInstr.getText());
            }
            return sb.toString();
        }

        public int match(String[] matchTokens, int startToken, int endToken, String originalText, DifferenceDescription differences, Map<Integer, LineColumn> tokenToLocation) throws LicenseParserException {
            return this.match(matchTokens, startToken, endToken, originalText, differences, tokenToLocation, false);
        }

        public int match(String[] matchTokens, int startToken, int endToken, String originalText, DifferenceDescription differences, Map<Integer, LineColumn> tokenToLocation, boolean ignoreOptionalDifferences) throws LicenseParserException {
            if (this.skip) {
                return startToken;
            }
            int nextToken = startToken;
            if (this.rule == null) {
                if (this.text != null) {
                    HashMap<Integer, LineColumn> textLocations = new HashMap<Integer, LineColumn>();
                    String[] textTokens = LicenseCompareHelper.tokenizeLicenseText(this.text, textLocations);
                    if (this.skipFirstTextToken) {
                        textTokens = Arrays.copyOfRange(textTokens, 1, textTokens.length);
                    }
                    if ((nextToken = CompareTemplateOutputHandler.this.compareText(textTokens, matchTokens, nextToken, endToken, this)) < 0) {
                        int errorLocation = -nextToken;
                        differences.addDifference(tokenToLocation.get(errorLocation), LicenseCompareHelper.getTokenAt(matchTokens, errorLocation), "Normal text of license does not match", this.text, null, this.getLastOptionalDifference());
                    }
                    if (this.subInstructions.size() > 0) {
                        throw new LicenseParserException("License template parser error.  Sub expressions are not allows for plain text.");
                    }
                } else {
                    for (ParseInstruction sub : this.subInstructions) {
                        nextToken = sub.match(matchTokens, nextToken, endToken, originalText, differences, tokenToLocation, ignoreOptionalDifferences);
                        if (nextToken >= 0) continue;
                        return nextToken;
                    }
                }
            } else if (this.rule.getType().equals((Object)LicenseTemplateRule.RuleType.BEGIN_OPTIONAL)) {
                if (this.getText() != null) {
                    throw new LicenseParserException("License template parser error - can not have text associated with a begin optional rule");
                }
                if (this.onlyText() || this.parent == null) {
                    for (ParseInstruction sub : this.subInstructions) {
                        DifferenceDescription optionalDifference;
                        nextToken = sub.match(matchTokens, nextToken, endToken, originalText, optionalDifference = new DifferenceDescription(), tokenToLocation);
                        if (nextToken >= 0) continue;
                        if (!ignoreOptionalDifferences) {
                            this.setLastOptionalDifference(optionalDifference);
                        }
                        return startToken;
                    }
                } else {
                    List<Integer> matchingNormalTextStartTokens = this.parent.findNextNonVarTextStartTokens(this, matchTokens, startToken, endToken, originalText, differences, tokenToLocation);
                    nextToken = this.matchOptional(matchingNormalTextStartTokens, matchTokens, nextToken, endToken, originalText, differences, tokenToLocation, ignoreOptionalDifferences);
                }
            } else if (this.rule.getType().equals((Object)LicenseTemplateRule.RuleType.VARIABLE)) {
                List<Integer> matchingNormalTextStartTokens = this.parent.findNextNonVarTextStartTokens(this, matchTokens, startToken, endToken, originalText, differences, tokenToLocation);
                nextToken = this.matchVariable(matchingNormalTextStartTokens, matchTokens, nextToken, endToken, originalText, differences, tokenToLocation);
            } else {
                throw new LicenseParserException("Unexpected parser state - instruction is not root, optional, variable or text");
            }
            return nextToken;
        }

        private int matchOptional(List<Integer> matchingStartTokens, String[] matchTokens, int startToken, int endToken, String originalText, DifferenceDescription differences, Map<Integer, LineColumn> tokenToLocation, boolean ignoreOptionalDifferences) throws LicenseParserException {
            for (int matchingStartToken : matchingStartTokens) {
                DifferenceDescription matchDifferences = new DifferenceDescription();
                int matchLocation = startToken;
                for (ParseInstruction sub : this.subInstructions) {
                    matchLocation = sub.match(matchTokens, matchLocation, matchingStartToken - 1, originalText, matchDifferences, tokenToLocation);
                    if (matchLocation < 0) break;
                }
                if (matchLocation > 0) {
                    return matchLocation;
                }
                if (ignoreOptionalDifferences) continue;
                this.setLastOptionalDifference(matchDifferences);
            }
            return startToken;
        }

        /*
         * Unable to fully structure code
         */
        private List<Integer> findNextNonVarTextStartTokens(ParseInstruction afterChild, String[] matchTokens, int startToken, int endToken, String originalText, DifferenceDescription differences, Map<Integer, LineColumn> tokenToLocation) throws LicenseParserException {
            retval = new ArrayList<Integer>();
            indexOfChild = this.subInstructions.indexOf(afterChild);
            if (indexOfChild < 0) {
                throw new LicenseParserException("Template Parser Error: Could not locate sub instruction");
            }
            startSubinstructionIndex = indexOfChild + 1;
            if (startSubinstructionIndex >= this.subInstructions.size()) {
                retval.add(endToken + 1);
                return retval;
            }
            firstNormalTextIndex = -1;
            leadingOptionalSubInstructions = new ArrayList<Integer>();
            i = startSubinstructionIndex;
            while (i < this.subInstructions.size() && firstNormalTextIndex < 0) {
                subInstructionRule = this.subInstructions.get(i).getRule();
                if (subInstructionRule != null && subInstructionRule.getType() == LicenseTemplateRule.RuleType.BEGIN_OPTIONAL) {
                    leadingOptionalSubInstructions.add(i);
                } else if (this.subInstructions.get(i).getText() != null && !this.subInstructions.get(i).getText().trim().isEmpty()) {
                    firstNormalTextIndex = i;
                }
                ++i;
            }
            nextMatchingStart = startToken;
            var16_16 = leadingOptionalSubInstructions.iterator();
            while (var16_16.hasNext()) {
                optionalSub = (Integer)var16_16.next();
                tempDiffDescription = new DifferenceDescription();
                nextOptMatchingStart = nextMatchingStart;
                optTokenAfterMatch = this.subInstructions.get(optionalSub).match(matchTokens, nextOptMatchingStart, endToken, originalText, tempDiffDescription, tokenToLocation, true);
                while (optTokenAfterMatch <= nextOptMatchingStart && -optTokenAfterMatch <= endToken && !DifferenceDescription.access$0(tempDiffDescription) && nextOptMatchingStart <= endToken) {
                    optTokenAfterMatch = this.subInstructions.get(optionalSub).match(matchTokens, ++nextOptMatchingStart, endToken, originalText, tempDiffDescription, tokenToLocation, true);
                }
                if (optTokenAfterMatch <= 0 || DifferenceDescription.access$0(tempDiffDescription) || nextOptMatchingStart > endToken) continue;
                if (optTokenAfterMatch - nextOptMatchingStart > 3) {
                    retval.add(nextOptMatchingStart);
                }
                nextMatchingStart = optTokenAfterMatch;
            }
            if (firstNormalTextIndex < 0) {
                retval.add(endToken + 1);
                return retval;
            }
            normalTextLocations = new HashMap<Integer, LineColumn>();
            textTokens = LicenseCompareHelper.tokenizeLicenseText(this.subInstructions.get(firstNormalTextIndex).getText(), normalTextLocations);
            if (textTokens.length > 15) {
                textTokens = Arrays.copyOf(textTokens, 15);
            }
            tokenAfterMatch = CompareTemplateOutputHandler.access$0(CompareTemplateOutputHandler.this, textTokens, matchTokens, nextMatchingStart, endToken, null);
            foundEnoughTokens = false;
            ** GOTO lbl80
            {
                tokenAfterMatch = CompareTemplateOutputHandler.access$0(CompareTemplateOutputHandler.this, textTokens, matchTokens, ++nextMatchingStart, endToken, null);
                do {
                    if (tokenAfterMatch < 0 && -tokenAfterMatch <= endToken) continue block3;
                    if (tokenAfterMatch < 0) {
                        ruleDesc = "variable or optional rule";
                        if (afterChild.getRule() != null) {
                            if (afterChild.getRule().getType() == LicenseTemplateRule.RuleType.BEGIN_OPTIONAL) {
                                ruleDesc = "optional rule";
                            } else if (afterChild.getRule().getType() == LicenseTemplateRule.RuleType.VARIABLE) {
                                ruleDesc = "variable rule '" + afterChild.getRule().getName() + "'";
                            }
                        }
                        differences.addDifference(tokenToLocation.get(nextMatchingStart), "", "Unable to find the text '" + this.subInstructions.get(firstNormalTextIndex).getText() + "' following a " + ruleDesc, null, this.rule, this.getLastOptionalDifference());
                        continue;
                    }
                    if (textTokens.length >= 3) {
                        retval.add(nextMatchingStart);
                        foundEnoughTokens = true;
                        continue;
                    }
                    tempDiffDescription = new DifferenceDescription();
                    nextCheckToken = this.subInstructions.get(firstNormalTextIndex).match(matchTokens, nextMatchingStart, endToken, originalText, tempDiffDescription, tokenToLocation, true);
                    nextCheckSubInstruction = firstNormalTextIndex + 1;
                    while (nextCheckToken > 0 && nextCheckToken - tokenAfterMatch < 3 && nextCheckSubInstruction < this.subInstructions.size()) {
                        nextCheckToken = this.subInstructions.get(nextCheckSubInstruction++).match(matchTokens, nextCheckToken, endToken, originalText, tempDiffDescription, tokenToLocation, true);
                    }
                    if (nextCheckToken < 0) {
                        tokenAfterMatch = CompareTemplateOutputHandler.access$0(CompareTemplateOutputHandler.this, textTokens, matchTokens, ++nextMatchingStart, endToken, null);
                        continue;
                    }
                    retval.add(nextMatchingStart);
                    foundEnoughTokens = true;
lbl80:
                    // 5 sources

                } while (!foundEnoughTokens && nextMatchingStart <= endToken && !DifferenceDescription.access$0(differences));
            }
            return retval;
        }

        private int numTokensMatched(String text, int end) {
            if (text.trim().isEmpty()) {
                return 0;
            }
            if (end == 0) {
                return 0;
            }
            HashMap<Integer, LineColumn> temp = new HashMap<Integer, LineColumn>();
            String subText = text.substring(0, end);
            String[] tokenizedString = LicenseCompareHelper.tokenizeLicenseText(subText, temp);
            return tokenizedString.length;
        }

        private int matchVariable(List<Integer> matchingStartTokens, String[] matchTokens, int startToken, int endToken, String originalText, DifferenceDescription differences, Map<Integer, LineColumn> tokenToLocation) {
            if (differences.isDifferenceFound()) {
                return -1;
            }
            for (int matchingStartToken : matchingStartTokens) {
                String compareText = LicenseCompareHelper.locateOriginalText(originalText, startToken, matchingStartToken - 1, tokenToLocation, matchTokens);
                Pattern matchPattern = Pattern.compile(this.rule.getMatch(), 34);
                Matcher matcher = matchPattern.matcher(compareText);
                if (!matcher.find() || matcher.start() > 0) continue;
                int numMatched = this.numTokensMatched(compareText, matcher.end());
                return startToken + numMatched;
            }
            differences.addDifference(tokenToLocation.get(startToken), LicenseCompareHelper.getTokenAt(matchTokens, startToken), "Variable text rule " + this.rule.getName() + " did not match the compare text", null, this.rule, this.getLastOptionalDifference());
            return -1;
        }

        public DifferenceDescription getLastOptionalDifference() {
            if (this.lastOptionalDifference != null) {
                return this.lastOptionalDifference;
            }
            if (this.parent != null) {
                return this.parent.getLastOptionalDifference();
            }
            return null;
        }

        public void setLastOptionalDifference(DifferenceDescription optionalDifference) {
            if (optionalDifference != null && optionalDifference.getDifferenceMessage() != null && !optionalDifference.getDifferenceMessage().isEmpty()) {
                this.lastOptionalDifference = optionalDifference;
                if (this.parent != null) {
                    this.parent.setLastOptionalDifference(optionalDifference);
                }
            }
        }

        public boolean isFollowingInstructionOptionalSingleToken() {
            if (this.parent == null) {
                return false;
            }
            ParseInstruction nextInstruction = this.parent.findFollowingInstruction(this);
            if (nextInstruction == null || nextInstruction.getRule() == null) {
                return false;
            }
            if (!LicenseTemplateRule.RuleType.BEGIN_OPTIONAL.equals((Object)nextInstruction.getRule().getType())) {
                return false;
            }
            if (nextInstruction.getSubInstructions().size() != 1) {
                return false;
            }
            String optionalText = nextInstruction.getSubInstructions().get(0).getText();
            return LicenseCompareHelper.isSingleTokenString(optionalText);
        }

        private ParseInstruction findFollowingInstruction(ParseInstruction parseInstruction) {
            if (parseInstruction == null) {
                return null;
            }
            int i = 0;
            while (i < this.subInstructions.size()) {
                if (parseInstruction.equals(this.subInstructions.get(i))) {
                    if (this.subInstructions.size() > i + 1) {
                        return this.subInstructions.get(i + 1);
                    }
                    if (this.parent == null) {
                        return null;
                    }
                    return this.parent.findFollowingInstruction(this);
                }
                ++i;
            }
            return null;
        }

        public String[] getNextOptionalTextTokens() {
            if (this.parent == null) {
                return new String[0];
            }
            ParseInstruction nextInstruction = this.parent.findFollowingInstruction(this);
            if (nextInstruction == null || nextInstruction.getRule() == null) {
                return new String[0];
            }
            if (!LicenseTemplateRule.RuleType.BEGIN_OPTIONAL.equals((Object)nextInstruction.getRule().getType())) {
                return new String[0];
            }
            StringBuilder sb = new StringBuilder();
            for (ParseInstruction inst : nextInstruction.getSubInstructions()) {
                if (inst.getText() == null) continue;
                sb.append(inst.getText());
            }
            HashMap<Integer, LineColumn> temp = new HashMap<Integer, LineColumn>();
            return LicenseCompareHelper.tokenizeLicenseText(sb.toString(), temp);
        }

        public void skipNextInstruction() {
            if (this.parent == null) {
                return;
            }
            ParseInstruction nextInst = this.parent.findFollowingInstruction(this);
            if (Objects.nonNull(nextInst)) {
                nextInst.setSkip(true);
            }
        }

        public boolean getSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public ParseInstruction getNextNormalTextInstruction() {
            if (this.parent == null) {
                return null;
            }
            List<ParseInstruction> siblings = this.parent.getSubInstructions();
            int mySiblingIndex = -1;
            int i = 0;
            while (i < siblings.size()) {
                if (this.equals(siblings.get(i))) {
                    mySiblingIndex = i;
                    break;
                }
                ++i;
            }
            if (mySiblingIndex < 0) {
                return null;
            }
            int nextOptionalIndex = -1;
            int i2 = mySiblingIndex + 1;
            while (i2 < siblings.size()) {
                if (siblings.get(i2).getRule() != null && LicenseTemplateRule.RuleType.BEGIN_OPTIONAL.equals((Object)siblings.get(i2).getRule().getType())) {
                    nextOptionalIndex = i2;
                    break;
                }
                ++i2;
            }
            if (nextOptionalIndex > 0) {
                i2 = nextOptionalIndex + 1;
                while (i2 < siblings.size()) {
                    if (siblings.get(i2).getText() != null) {
                        return siblings.get(i2);
                    }
                    ++i2;
                }
                return null;
            }
            return this.parent.getNextNormalTextInstruction();
        }

        public void setSkipFirstToken(boolean skipFirstTextToken) {
            this.skipFirstTextToken = skipFirstTextToken;
        }

        public boolean isSkipFirstTextToken() {
            return this.skipFirstTextToken;
        }
    }
}

