/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;
import org.spdx.utility.compare.SpdxItemDifference;

public class SpdxFileDifference
extends SpdxItemDifference {
    private List<FileType> fileTypeA;
    private List<FileType> fileTypeB;
    private List<String> contributorsA;
    private String noticeA;
    private List<String> contributorsB;
    private String noticeB;
    private List<String> dependantFileNamesA;
    private List<String> dependantFileNamesB;
    private boolean checksumsEquals;
    private List<Checksum> uniqueChecksumsA;
    private List<Checksum> uniqueChecksumsB;
    private String spdxIdA;
    private String spdxIdB;

    public SpdxFileDifference(SpdxFile fileA, SpdxFile fileB, boolean concludedLicensesEqual, boolean seenLicensesEqual, List<AnyLicenseInfo> uniqueSeenLicensesA, List<AnyLicenseInfo> uniqueSeenLicensesB, boolean checksumsEquals, List<Checksum> uniqueChecksumsA, List<Checksum> uniqueChecksumsB, boolean relationshipsEquals, List<Relationship> uniqueRelationshipA, List<Relationship> uniqueRelationshipB, boolean annotationsEquals, List<Annotation> uniqueAnnotationsA, List<Annotation> uniqueAnnotationsB) throws InvalidSPDXAnalysisException, SpdxCompareException {
        super(fileA, fileB, concludedLicensesEqual, seenLicensesEqual, uniqueSeenLicensesA, uniqueSeenLicensesB, relationshipsEquals, uniqueRelationshipA, uniqueRelationshipB, annotationsEquals, uniqueAnnotationsA, uniqueAnnotationsB);
        Optional<String> dependantFileName;
        this.fileTypeA = Arrays.asList(fileA.getFileTypes().toArray(new FileType[fileA.getFileTypes().size()]));
        this.fileTypeB = Arrays.asList(fileB.getFileTypes().toArray(new FileType[fileB.getFileTypes().size()]));
        this.contributorsA = Arrays.asList(fileA.getFileContributors().toArray(new String[fileA.getFileContributors().size()]));
        this.contributorsB = Arrays.asList(fileB.getFileContributors().toArray(new String[fileB.getFileContributors().size()]));
        this.dependantFileNamesA = new ArrayList<String>();
        for (SpdxFile dependantFile : fileA.getFileDependency()) {
            dependantFileName = dependantFile.getName();
            if (!dependantFileName.isPresent()) continue;
            this.dependantFileNamesA.add(dependantFileName.get());
        }
        this.dependantFileNamesB = new ArrayList<String>();
        for (SpdxFile dependantFile : fileB.getFileDependency()) {
            dependantFileName = dependantFile.getName();
            if (!dependantFileName.isPresent()) continue;
            this.dependantFileNamesB.add(dependantFileName.get());
        }
        Optional<String> noticeTextA = fileA.getNoticeText();
        this.noticeA = noticeTextA.isPresent() ? noticeTextA.get() : "";
        Optional<String> noticeTextB = fileB.getNoticeText();
        this.noticeB = noticeTextB.isPresent() ? noticeTextB.get() : "";
        this.checksumsEquals = checksumsEquals;
        this.uniqueChecksumsA = uniqueChecksumsA;
        this.uniqueChecksumsB = uniqueChecksumsB;
        this.spdxIdA = fileA.getId();
        this.spdxIdB = fileB.getId();
    }

    public String getFileName() {
        return this.getName();
    }

    public List<FileType> getFileTypeA() {
        return this.fileTypeA;
    }

    public List<FileType> getFileTypeB() {
        return this.fileTypeB;
    }

    public boolean isContributorsEqual() {
        return SpdxComparer.stringListsEqual(this.contributorsA, this.contributorsB);
    }

    public boolean isNoticeTextsEqual() {
        return SpdxComparer.stringsEqual(this.noticeA, this.noticeB);
    }

    public boolean isFileDependenciesEqual() {
        return SpdxComparer.stringListsEqual(this.dependantFileNamesA, this.dependantFileNamesB);
    }

    public boolean isTypeEqual() {
        return SpdxComparer.listsEquals(this.fileTypeA, this.fileTypeB);
    }

    public boolean isChecksumsEquals() {
        return this.checksumsEquals;
    }

    public String getContributorsAAsString() {
        return SpdxFileDifference.stringListToString(this.contributorsA);
    }

    public String getContributorsBAsString() {
        return SpdxFileDifference.stringListToString(this.contributorsB);
    }

    static String stringListToString(List<String> s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && s.size() > 0) {
            sb.append(s.get(0));
            int i = 1;
            while (i < s.size()) {
                if (Objects.nonNull(s.get(i)) && !s.get(i).isEmpty()) {
                    sb.append(", ");
                    sb.append(s.get(i));
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String getFileDependenciesAAsString() {
        return SpdxFileDifference.stringListToString(this.dependantFileNamesA);
    }

    public String getFileDependenciesBAsString() {
        return SpdxFileDifference.stringListToString(this.dependantFileNamesB);
    }

    public List<String> getContributorsA() {
        return this.contributorsA;
    }

    public String getNoticeA() {
        return this.noticeA;
    }

    public List<String> getContributorsB() {
        return this.contributorsB;
    }

    public String getNoticeB() {
        return this.noticeB;
    }

    public List<String> getDependantFileNamesA() {
        return this.dependantFileNamesA;
    }

    public List<String> getDependantFileNamesB() {
        return this.dependantFileNamesB;
    }

    public List<Checksum> getUniqueChecksumsA() {
        return this.uniqueChecksumsA;
    }

    public List<Checksum> getUniqueChecksumsB() {
        return this.uniqueChecksumsB;
    }

    public String getSpdxIdA() {
        return this.spdxIdA;
    }

    public String getSpdxIdB() {
        return this.spdxIdB;
    }
}

