/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.verificationcode;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.storage.IModelStore;
import org.spdx.utility.verificationcode.IFileChecksumGenerator;

public class VerificationCodeGenerator {
    private IFileChecksumGenerator fileChecksumGenerator;

    public VerificationCodeGenerator(IFileChecksumGenerator fileChecksumGenerator) {
        this.fileChecksumGenerator = fileChecksumGenerator;
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(SpdxFile[] spdxFiles, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        if (spdxFiles == null) {
            return null;
        }
        TreeSet<String> skippedFilePathSet = new TreeSet<String>();
        if (skippedFilePaths != null) {
            int i = 0;
            while (i < skippedFilePaths.length) {
                if (skippedFilePaths[i] != null) {
                    skippedFilePathSet.add(skippedFilePaths[i]);
                }
                ++i;
            }
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        int i = 0;
        while (i < spdxFiles.length) {
            Optional<String> name;
            if (spdxFiles[i] != null && (name = spdxFiles[i].getName()).isPresent() && !skippedFilePathSet.contains(name.get())) {
                fileChecksums.add(spdxFiles[i].getSha1());
            }
            ++i;
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFilePathSet.toArray(new String[skippedFilePathSet.size()]), modelStore, documentUri);
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, File[] skippedFiles, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        TreeSet<String> skippedFilesPath = new TreeSet<String>();
        String rootOfDirectory = sourceDirectory.getAbsolutePath();
        int rootLen = rootOfDirectory.length() + 1;
        int i = 0;
        while (i < skippedFiles.length) {
            String skippedPath = VerificationCodeGenerator.normalizeFilePath(skippedFiles[i].getAbsolutePath().substring(rootLen));
            skippedFilesPath.add(skippedPath);
            ++i;
        }
        ArrayList<String> fileChecksums = new ArrayList<String>();
        this.collectFileData(rootOfDirectory, sourceDirectory, fileChecksums, skippedFilesPath);
        String[] skippedFileNames = new String[skippedFilesPath.size()];
        Iterator iter = skippedFilesPath.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            skippedFileNames[i2++] = (String)iter.next();
        }
        return this.generatePackageVerificationCode(fileChecksums, skippedFileNames, modelStore, documentUri);
    }

    protected SpdxPackageVerificationCode generatePackageVerificationCode(List<String> fileChecksums, String[] skippedFilePaths, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, InvalidSPDXAnalysisException {
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        int i = 0;
        while (i < fileChecksums.size()) {
            byte[] hashInput = fileChecksums.get(i).getBytes(Charset.forName("UTF-8"));
            verificationCodeDigest.update(hashInput);
            ++i;
        }
        String value = VerificationCodeGenerator.convertChecksumToString(verificationCodeDigest.digest());
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(modelStore, documentUri, modelStore.getNextId(IModelStore.IdType.Anonymous, documentUri), null, true);
        retval.setValue(value);
        String[] stringArray = skippedFilePaths;
        int n = skippedFilePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String skippedPath = stringArray[n2];
            retval.getExcludedFileNames().add(skippedPath);
            ++n2;
        }
        return retval;
    }

    private void collectFileData(String prefixForRelative, File sourceDirectory, List<String> fileNameAndChecksums, Set<String> skippedFiles) throws IOException {
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        File[] filesAndDirs = sourceDirectory.listFiles();
        if (filesAndDirs == null) {
            return;
        }
        int i = 0;
        while (i < filesAndDirs.length) {
            if (filesAndDirs[i].isDirectory()) {
                this.collectFileData(prefixForRelative, filesAndDirs[i], fileNameAndChecksums, skippedFiles);
            } else {
                String filePath = VerificationCodeGenerator.normalizeFilePath(filesAndDirs[i].getAbsolutePath().substring(prefixForRelative.length() + 1));
                if (!skippedFiles.contains(filePath)) {
                    String checksumValue = this.fileChecksumGenerator.getFileChecksum(filesAndDirs[i]).toLowerCase();
                    fileNameAndChecksums.add(checksumValue);
                }
            }
            ++i;
        }
    }

    public static String normalizeFilePath(String nonNormalizedFilePath) {
        String filePath = nonNormalizedFilePath.replace('\\', '/').trim();
        if (filePath.contains("../")) {
            String[] filePathParts = filePath.split("/");
            StringBuilder normalizedFilePath = new StringBuilder();
            int j = 0;
            while (j < filePathParts.length) {
                if (!(j + 1 < filePathParts.length && filePathParts[j + 1].equals("..") || filePathParts[j].equals(".."))) {
                    if (j > 0) {
                        normalizedFilePath.append('/');
                    }
                    normalizedFilePath.append(filePathParts[j]);
                }
                ++j;
            }
            filePath = normalizedFilePath.toString();
        }
        filePath = !(filePath = filePath.replace("./", "")).isEmpty() && filePath.charAt(0) == '/' ? "." + filePath : "./" + filePath;
        return filePath;
    }

    private static String convertChecksumToString(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < digest.length) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public SpdxPackageVerificationCode generatePackageVerificationCode(File sourceDirectory, IModelStore modelStore, String documentUri) throws NoSuchAlgorithmException, IOException, InvalidSPDXAnalysisException {
        return this.generatePackageVerificationCode(sourceDirectory, new File[0], modelStore, documentUri);
    }
}

