/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.base.module;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.base.module.SubsystemLifecycle;
import org.apache.jena.base.module.SubsystemRegistry;
import org.apache.jena.base.module.SubsystemRegistryServiceLoader;

public class Subsystem<T extends SubsystemLifecycle> {
    private Class<T> interfaceClass;
    private boolean DEBUG_INIT = false;
    private volatile boolean initialized = false;
    private Object initLock;
    private SubsystemRegistry<T> singleton = null;
    private static Comparator<SubsystemLifecycle> comparator = (obj1, obj2) -> Integer.compare(obj1.level(), obj2.level());
    private static Comparator<SubsystemLifecycle> reverseComparator = comparator.reversed();

    public Subsystem(Class<T> cls) {
        this.interfaceClass = cls;
        this.initLock = cls;
    }

    public void debug(boolean value) {
        this.DEBUG_INIT = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.initialized) {
                this.logLifecycle("Subsystem.init - return", new Object[0]);
                return;
            }
            this.initialized = true;
            this.logLifecycle("Subsystem.init - start", new Object[0]);
            if (this.get() == null) {
                SubsystemRegistryServiceLoader<T> x = new SubsystemRegistryServiceLoader<T>(this.interfaceClass);
                this.setSubsystemRegistry(x);
            }
            this.get().load();
            if (this.DEBUG_INIT) {
                this.logLifecycle("Found:", new Object[0]);
                this.get().snapshot().forEach((? super T mod) -> this.logLifecycle("  %-20s [%d]", mod.getClass().getSimpleName(), mod.level()));
            }
            if (this.DEBUG_INIT) {
                this.logLifecycle("Initialization sequence:", new Object[0]);
                this.forEach(module -> this.logLifecycle("  %-20s [%d]", module.getClass().getSimpleName(), module.level()));
            }
            this.forEach(module -> {
                this.logLifecycle("Init: %s", module.getClass().getSimpleName());
                module.start();
            });
            this.logLifecycle("Subsystem.init - finish", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.initialized) {
            this.logLifecycle("JenaSystem.shutdown - not initialized", new Object[0]);
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (!this.initialized) {
                this.logLifecycle("JenaSystem.shutdown - return", new Object[0]);
                return;
            }
            this.logLifecycle("JenaSystem.shutdown - start", new Object[0]);
            this.forEachReverse(module -> {
                this.logLifecycle("Stop: %s", module.getClass().getSimpleName());
                module.stop();
            });
            this.initialized = false;
            this.logLifecycle("JenaSystem.shutdown - finish", new Object[0]);
        }
    }

    public void setSubsystemRegistry(SubsystemRegistry<T> thing) {
        this.singleton = thing;
    }

    protected SubsystemRegistry<T> get() {
        return this.singleton;
    }

    public void forEach(Consumer<T> action) {
        this.forEach(action, comparator);
    }

    public void forEachReverse(Consumer<T> action) {
        this.forEach(action, reverseComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void forEach(Consumer<T> action, Comparator<SubsystemLifecycle> ordering) {
        Object object = this.initLock;
        synchronized (object) {
            List<T> x = this.get().snapshot();
            Collections.sort(x, ordering);
            x.forEach(action);
        }
    }

    public void logLifecycle(String fmt, Object ... args) {
        if (!this.DEBUG_INIT) {
            return;
        }
        System.err.printf(fmt, args);
        System.err.println();
    }
}

