/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowSetReaderTSV
implements RowSetReader {
    private static Logger log = LoggerFactory.getLogger(RowSetReaderTSV.class);
    public static final RowSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_TSV)) {
            throw new ResultSetException("RowSetReader for TSV asked for a " + lang);
        }
        return new RowSetReaderTSV();
    };
    static Pattern pattern = Pattern.compile("\t");

    private RowSetReaderTSV() {
    }

    @Override
    public QueryExecResult readAny(InputStream in, Context context2) {
        RowSet resultSet = RowSetReaderTSV.resultSetFromTSV(in);
        return new QueryExecResult(resultSet);
    }

    @Override
    public RowSet read(InputStream in, Context context2) {
        return RowSetReaderTSV.resultSetFromTSV(in);
    }

    public static RowSet resultSetFromTSV(InputStream in) {
        ArrayList<Var> vars;
        BufferedReader reader;
        block7: {
            reader = IO.asBufferedUTF8(in);
            vars = new ArrayList<Var>();
            String str2 = null;
            try {
                String[] tokens;
                str2 = reader.readLine();
                if (str2 == null) {
                    throw new ARQException("TSV Results malformed, input is empty (no header row)");
                }
                if (str2.isEmpty()) break block7;
                for (String token : tokens = pattern.split(str2, -1)) {
                    Node v;
                    try {
                        v = NodeFactoryExtra.parseNode(token);
                        if (v == null || !v.isVariable()) {
                            throw new ResultSetException("TSV Results malformed, not a variable: " + token);
                        }
                    }
                    catch (RiotException ex) {
                        throw new ResultSetException("TSV Results malformed, variable names must begin with a ? in the header: " + token);
                    }
                    Var var = Var.alloc(v);
                    vars.add(var);
                }
            }
            catch (IOException ex) {
                throw new ARQException(ex);
            }
        }
        return RowSetStream.create(vars, new TSVInputIterator(reader, vars));
    }

    public static boolean booleanFromTSV(InputStream in) {
        BufferedReader reader = IO.asBufferedUTF8(in);
        String str2 = null;
        try {
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("TSV Boolean Results malformed, input is empty");
            }
            if (!(str2 = str2.trim()).equals("?_askResult")) {
                throw new ARQException("TSV Boolean Results malformed, did not get expected ?_askResult header row");
            }
            str2 = reader.readLine();
            if (str2 == null) {
                throw new ARQException("TSV Boolean Results malformed, unexpected end of input after header row");
            }
            if ((str2 = str2.trim()).equalsIgnoreCase("true") || str2.equalsIgnoreCase("yes")) {
                return true;
            }
            if (str2.equalsIgnoreCase("false") || str2.equalsIgnoreCase("no")) {
                return false;
            }
            throw new ARQException("TSV Boolean Results malformed, expected one of - true yes false no - but got " + str2);
        }
        catch (IOException ex) {
            throw new ARQException(ex);
        }
    }

    static class TSVInputIterator
    implements Iterator<Binding> {
        private BufferedReader reader;
        private Binding currentBinding;
        private int expectedItems;
        private List<Var> vars;
        private long lineNum = 1L;
        private boolean finished = false;

        TSVInputIterator(BufferedReader reader, List<Var> vars) {
            Objects.requireNonNull(reader);
            this.reader = reader;
            this.expectedItems = vars.size();
            this.vars = vars;
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.currentBinding == null) {
                this.currentBinding = this.parseNextBinding();
            }
            if (this.currentBinding == null) {
                IO.close(this.reader);
                this.finished = true;
            }
            return !this.finished;
        }

        @Override
        public Binding next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Binding row = this.currentBinding;
            this.currentBinding = null;
            return row;
        }

        private Binding parseNextBinding() {
            String line;
            try {
                line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                ++this.lineNum;
            }
            catch (IOException e2) {
                throw new ResultSetException("Error parsing TSV results - " + e2.getMessage());
            }
            if (line.isEmpty()) {
                if (this.expectedItems > 1) {
                    throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row had 0/1 values when %d were expected", this.lineNum, this.expectedItems));
                }
                return BindingFactory.empty();
            }
            String[] tokens = pattern.split(line, -1);
            if (tokens.length != this.expectedItems) {
                throw new ResultSetException(String.format("Error Parsing TSV results at Line %d - The result row '%s' has %d values instead of the expected %d.", this.lineNum, line, tokens.length, this.expectedItems));
            }
            BindingBuilder builder = Binding.builder();
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (token.equals("")) continue;
                try {
                    Node node = NodeFactoryExtra.parseNode(token);
                    if (!node.isConcrete()) {
                        throw new ResultSetException(String.format("Line %d: Not a concrete RDF term: %s", this.lineNum, token));
                    }
                    builder.add(this.vars.get(i), node);
                    continue;
                }
                catch (RiotException ex) {
                    throw new ResultSetException(String.format("Line %d: Data %s contains error: %s", this.lineNum, token, ex.getMessage()));
                }
            }
            return builder.build();
        }
    }
}

