/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.single;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.exec.http.Service;
import org.apache.jena.sparql.service.single.ServiceExecutor;
import org.apache.jena.sparql.util.Context;

public class ServiceExecutorHttp
implements ServiceExecutor {
    @Override
    public QueryIterator createExecution(OpService opExecute, OpService opOriginal, Binding binding, ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        if (context2.isFalse(Service.httpServiceAllowed)) {
            throw new QueryExecException("SERVICE not allowed");
        }
        if (context2.isFalse(Service.serviceAllowed)) {
            throw new QueryExecException("SERVICE not allowed");
        }
        boolean silent = opExecute.getSilent();
        try {
            QueryIterator qIter = Service.exec(opExecute, context2);
            if (qIter == null) {
                throw new QueryExecException("No SERVICE handler");
            }
            qIter = QueryIter.makeTracked(qIter, execCxt);
            return new QueryIterCommonParent(qIter, binding, execCxt);
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn(this, "SERVICE " + NodeFmtLib.strTTL(opExecute.getService()) + " : " + ex.getMessage());
                return QueryIterSingleton.create(binding, execCxt);
            }
            throw ex;
        }
    }
}

